/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.rnc;

import com.adobe.aem.formsndocuments.util.FMConstants;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.ui.JcrPayloadPathBuilder;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, immediate=true)
@Service
@Properties(value={@Property(name="service.ranking", intValue={-5})})
public class RnCJcrPathBuilder
implements JcrPayloadPathBuilder {
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    private static final String GENERIC_FORMS_N_DOCUMENTS_PREFIX = "/aem/formdetails.html";
    private static final String FORMSET_PREFIX = "/aem/viewformset.html";
    @Reference(policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    private static Logger logger = LoggerFactory.getLogger(RnCJcrPathBuilder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String buildPath(WorkItem item) {
        logger.trace("Entering RncJcrPathBuilder buildPath.");
        if (item.getWorkflowData().getPayloadType().equals(TYPE_JCR_PATH)) {
            String path = item.getWorkflowData().getPayload().toString();
            logger.trace("Payload Path for RncJcrPathBuilder : " + path);
            Session bundleSession = null;
            try {
                Node assetNode;
                if (path.startsWith("/content/dam/formsanddocuments") && (assetNode = (bundleSession = FMUtils.getFnDServiceUserSession(this.repository)).getNode(path)) != null) {
                    FMConstants.CoreAssetType assetType = FMUtils.getAssetType(bundleSession, path);
                    if (assetType.equals((Object)FMConstants.CoreAssetType.FORMSET)) {
                        String string = FORMSET_PREFIX + path;
                        return string;
                    }
                    if (!assetType.equals((Object)FMConstants.CoreAssetType.NONFMASSET)) {
                        String string = GENERIC_FORMS_N_DOCUMENTS_PREFIX + path;
                        return string;
                    }
                }
            }
            catch (Exception e) {
                logger.trace("Error while retrieving type for asset " + path, e);
            }
            finally {
                if (bundleSession != null) {
                    bundleSession.logout();
                }
            }
        }
        logger.trace("Exiting RncJcrPathBuilder buildPath.");
        return null;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

