/*
* Asset Share Commons
*
* Copyright [2018]  Adobe
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*global moment:false, $:false */

$(function () {
    'use strict';

    /** Update case-sensitivity property according to selected option */

    $('.cmp-search-sort input[name="orderby"]').on('change', function() {
        var propertyName = $(this).val(),
            isCaseSensitive = $('.cmp-search-sort [data-value="' + propertyName + '"]').is('[data-asset-share-sort-case-sensitive]');

        $('.cmp-search-sort input[name="orderby.case"]').val(isCaseSensitive ? null : "ignore");
    });
});