/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.workflow.assetkit.impl;

import com.adobe.aem.commons.assetshare.util.WorkflowUtil;
import com.adobe.aem.commons.assetshare.util.assetkit.AssetKitHelper;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class}, property={"process.label=Asset kit activator"})
public class AssetKitReplicationWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AssetKitReplicationWorkflowProcess.class);
    private static final String WORKFLOW_REPLICATION_ACTIVATION_TYPE = "replicationActionType";
    @Reference
    private transient ReferenceProvider referenceProvider;
    @Reference
    private transient Replicator replicator;
    @Reference
    private transient AssetKitHelper assetKitHelper;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        String assetsKitPath = (String)((Object)WorkflowUtil.getPersistedData(workItem, "ASSETS_KIT_PATH", String.class));
        String assetsKitPagePath = (String)((Object)WorkflowUtil.getPersistedData(workItem, "ASSETS_KIT_PAGE_ID", String.class));
        ReplicationActionType replicationActionType = ReplicationActionType.valueOf((String)((String)metaDataMap.get(WORKFLOW_REPLICATION_ACTIVATION_TYPE, (Object)"ACTIVATE")));
        if (StringUtils.isBlank((CharSequence)assetsKitPath)) {
            throw new WorkflowException("Asset kit asset folder is blank");
        }
        if (StringUtils.isBlank((CharSequence)assetsKitPagePath)) {
            throw new WorkflowException("Asset kit page is blank");
        }
        if (((PageManager)resourceResolver.adaptTo(PageManager.class)).getPage(assetsKitPagePath) == null) {
            throw new WorkflowException(String.format("Asset kit page [ %s ] is not a page.", assetsKitPagePath));
        }
        if (resourceResolver.getResource(assetsKitPath) == null) {
            throw new WorkflowException(String.format("Asset kit [ %s ] does not exist.", assetsKitPath));
        }
        if (!this.assetKitHelper.isAssetFolder(resourceResolver.getResource(assetsKitPath)) && !this.assetKitHelper.isAssetCollection(resourceResolver.getResource(assetsKitPath))) {
            throw new WorkflowException(String.format("Asset kit asset [ %s ] is not an asset folder or a collection.", assetsKitPath));
        }
        Page assetsKitPage = ((PageManager)resourceResolver.adaptTo(PageManager.class)).getPage(assetsKitPagePath);
        try {
            this.replicator.replicate((Session)resourceResolver.adaptTo(Session.class), replicationActionType, assetsKitPath);
            this.assetKitHelper.getAssets(resourceResolver, new String[]{assetsKitPath}).forEach(asset -> {
                try {
                    this.replicator.replicate((Session)resourceResolver.adaptTo(Session.class), replicationActionType, asset.getPath());
                }
                catch (ReplicationException e) {
                    log.error("Error replicating asset [ {} ]", (Object)asset.getPath(), (Object)e);
                }
            });
            if (ReplicationActionType.ACTIVATE.equals((Object)replicationActionType)) {
                Resource pageResource = (Resource)assetsKitPage.adaptTo(Resource.class);
                while (!"/content".equals(pageResource.getPath())) {
                    if (ReplicationActionType.ACTIVATE.equals((Object)replicationActionType) && !this.replicator.getReplicationStatus(session, pageResource.getPath()).isActivated()) {
                        this.replicator.replicate(session, replicationActionType, pageResource.getPath());
                    }
                    pageResource = pageResource.getParent();
                }
            }
            List references = this.referenceProvider.findReferences(resourceResolver.getResource(assetsKitPage.getPath()));
            for (com.day.cq.wcm.api.reference.Reference reference : references) {
                this.replicator.replicate(session, replicationActionType, reference.getResource().getPath());
            }
            this.replicator.replicate(session, replicationActionType, assetsKitPage.getPath());
        }
        catch (ReplicationException e) {
            throw new WorkflowException(String.format("Failed to replicate asset kit [ %s ]", assetsKitPath), (Throwable)e);
        }
    }
}

