/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.adobe.aem.commons.assetshare.util.EmailService;
import com.day.cq.commons.mail.MailTemplate;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageGatewayService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.Session;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EmailService.class})
@Designate(ocd=Cfg.class)
public final class EmailServiceImpl
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Reference
    private transient MessageGatewayService messageGatewayService;
    @Reference
    private transient ResourceResolverFactory resourceResolverFactory;
    private static final String MSG_INVALID_RECIPIENTS = "Invalid Recipients";
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static String SERVICE_NAME = "email-service";
    private transient Cfg cfg;

    @Override
    public List<String> sendEmail(String templatePath, Map<String, String> emailParams, String ... recipients) {
        ArrayList<String> failureList = new ArrayList<String>();
        if (recipients == null || recipients.length == 0) {
            throw new IllegalArgumentException(MSG_INVALID_RECIPIENTS);
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(recipients.length);
        for (String recipient : recipients) {
            try {
                addresses.add(new InternetAddress(recipient));
            }
            catch (AddressException e) {
                log.warn("Invalid email address {} passed to sendEmail(). Skipping.", (Object)recipient);
            }
        }
        InternetAddress[] iAddressRecipients = addresses.toArray(new InternetAddress[addresses.size()]);
        List<InternetAddress> failureInternetAddresses = this.sendEmail(templatePath, emailParams, iAddressRecipients);
        for (InternetAddress address : failureInternetAddresses) {
            failureList.add(address.toString());
        }
        return failureList;
    }

    @Override
    public List<InternetAddress> sendEmail(String templatePath, Map<String, String> emailParams, InternetAddress ... recipients) {
        ArrayList<InternetAddress> failureList = new ArrayList<InternetAddress>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException(MSG_INVALID_RECIPIENTS);
        }
        MailTemplate mailTemplate = this.getMailTemplate(templatePath);
        Class<? extends Email> mailType = this.getMailType(templatePath);
        MessageGateway messageGateway = this.messageGatewayService.getGateway(mailType);
        for (InternetAddress address : recipients) {
            try {
                Email email = this.getEmail(mailTemplate, mailType, emailParams);
                email.setTo(Collections.singleton(address));
                messageGateway.send((Object)email);
            }
            catch (IOException | MessagingException | EmailException e) {
                failureList.add(address);
                if (!log.isErrorEnabled()) continue;
                log.error("Error sending email to [ " + address + " ]", e);
            }
        }
        return failureList;
    }

    @Override
    public List<InternetAddress> sendEmail(String templatePath, Map<String, String> emailParams, Map<String, DataSource> attachments, InternetAddress ... recipients) {
        ArrayList<InternetAddress> failureList = new ArrayList<InternetAddress>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException(MSG_INVALID_RECIPIENTS);
        }
        MailTemplate mailTemplate = this.getMailTemplate(templatePath);
        Class mailType = attachments != null && attachments.size() > 0 ? HtmlEmail.class : this.getMailType(templatePath);
        MessageGateway messageGateway = this.messageGatewayService.getGateway(mailType);
        for (InternetAddress address : recipients) {
            try {
                Email email = this.getEmail(mailTemplate, mailType, emailParams);
                email.setTo(Collections.singleton(address));
                if (attachments != null && attachments.size() > 0) {
                    for (Map.Entry<String, DataSource> entry : attachments.entrySet()) {
                        ((HtmlEmail)email).attach(entry.getValue(), entry.getKey(), null);
                    }
                }
                messageGateway.send((Object)email);
            }
            catch (IOException | MessagingException | EmailException e) {
                failureList.add(address);
                if (!log.isErrorEnabled()) continue;
                log.error("Error sending email to [ " + address + " ]", e);
            }
        }
        return failureList;
    }

    @Override
    public List<String> sendEmail(String templatePath, Map<String, String> emailParams, Map<String, DataSource> attachments, String ... recipients) {
        ArrayList<String> failureList = new ArrayList<String>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException(MSG_INVALID_RECIPIENTS);
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(recipients.length);
        for (String recipient : recipients) {
            try {
                addresses.add(new InternetAddress(recipient));
            }
            catch (AddressException e) {
                log.warn("Invalid email address {} passed to sendEmail(). Skipping.", (Object)recipient);
            }
        }
        InternetAddress[] iAddressRecipients = addresses.toArray(new InternetAddress[addresses.size()]);
        List<InternetAddress> failureInternetAddresses = this.sendEmail(templatePath, emailParams, attachments, iAddressRecipients);
        for (InternetAddress address : failureInternetAddresses) {
            failureList.add(address.toString());
        }
        return failureList;
    }

    private Email getEmail(MailTemplate mailTemplate, Class<? extends Email> mailType, Map<String, String> params) throws EmailException, MessagingException, IOException {
        Email email = mailTemplate.getEmail(StrLookup.mapLookup(params), mailType);
        if (params.containsKey("senderEmailAddress") && params.containsKey("senderName")) {
            email.setFrom(params.get("senderEmailAddress"), params.get("senderName"));
        } else if (params.containsKey("senderEmailAddress")) {
            email.setFrom(params.get("senderEmailAddress"));
        }
        if (this.cfg.connectTimeout() > 0) {
            email.setSocketConnectionTimeout(this.cfg.connectTimeout());
        }
        if (this.cfg.socketTimeout() > 0) {
            email.setSocketTimeout(this.cfg.socketTimeout());
        }
        if (params.containsKey("subject")) {
            email.setSubject(params.get("subject"));
        }
        if (params.containsKey("replyTo")) {
            email.addReplyTo(params.get("replyTo"));
        }
        return email;
    }

    private Class<? extends Email> getMailType(String templatePath) {
        return templatePath.endsWith(".html") ? HtmlEmail.class : SimpleEmail.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailTemplate getMailTemplate(String templatePath) throws IllegalArgumentException {
        MailTemplate mailTemplate = null;
        try (ResourceResolver resourceResolver = null;){
            Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SERVICE_NAME);
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(authInfo);
            mailTemplate = MailTemplate.create((String)templatePath, (Session)((Session)resourceResolver.adaptTo(Session.class)));
            if (mailTemplate == null) {
                throw new IllegalArgumentException("Mail template path [ " + templatePath + " ] could not resolve to a valid template");
            }
        }
        return mailTemplate;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - E-mail Service")
    public static @interface Cfg {
        @AttributeDefinition(name="Socket Timeout", description="Socket timeout in milliseconds.")
        public int socketTimeout() default 30000;

        @AttributeDefinition(name="Connect Timeout", description="Connect timeout in milliseconds.")
        public int connectTimeout() default 30000;
    }
}

