/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util;

import com.day.text.Text;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger log = LoggerFactory.getLogger(UrlUtil.class);

    public static final String escape(String unescaped) {
        if (unescaped == null) {
            return null;
        }
        return UrlUtil.escape(unescaped, true);
    }

    public static final String escape(String unescaped, boolean preventDoubleEscaping) {
        if (unescaped == null) {
            return null;
        }
        if (preventDoubleEscaping && UrlUtil.isEscaped(unescaped)) {
            return unescaped;
        }
        String tmp = unescaped;
        tmp = StringUtils.replace((String)tmp, (String)" ", (String)"%20");
        if (!UrlUtil.isPath(unescaped)) {
            try {
                URL url = new URL(tmp);
                String path = UrlUtil.escapePath(url.getPath());
                if (StringUtils.isNotBlank((CharSequence)url.getQuery())) {
                    path = path + "?" + url.getQuery();
                }
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), path).toString();
            }
            catch (MalformedURLException e) {
                log.warn("Could not evaluate unescaped string [ {} ] as a URL. Falling back to escape as path.", (Object)unescaped, (Object)e);
            }
        }
        return UrlUtil.escapePath(tmp);
    }

    public static final boolean isEscaped(String candidate) {
        if (candidate == null) {
            return false;
        }
        String unescaped = Text.unescape((String)StringUtils.stripToEmpty((String)candidate));
        if (!StringUtils.equals((CharSequence)(unescaped = StringUtils.replace((String)unescaped, (String)"/_jcr_content", (String)"/jcr:content")), (CharSequence)candidate)) {
            return true;
        }
        return StringUtils.equals((CharSequence)UrlUtil.escape(candidate, false), (CharSequence)candidate);
    }

    private static String escapePath(String path) {
        path = StringUtils.replace((String)path, (String)"%20", (String)" ");
        path = StringUtils.replace((String)path, (String)"/jcr:content", (String)"/_jcr_content");
        path = Text.escapePath((String)path);
        return path;
    }

    private static boolean isPath(String candidate) {
        if (StringUtils.isNotBlank((CharSequence)candidate)) {
            if (candidate.matches("^[a-zA-Z0-9]+://.+")) {
                return false;
            }
            if (StringUtils.startsWith((CharSequence)candidate, (CharSequence)"//")) {
                return false;
            }
        }
        return true;
    }
}

