/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.impl.predicateevaluators;

import com.adobe.aem.commons.assetshare.search.impl.predicateevaluators.PredicateEvaluatorUtil;
import com.day.cq.search.Predicate;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.FulltextPredicateEvaluator;
import com.day.cq.search.eval.JcrPropertyPredicateEvaluator;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.facets.FacetExtractor;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.query.Row;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(factory="com.day.cq.search.eval.PredicateEvaluator/propertyvalues")
@Designate(ocd=Cfg.class)
public class PropertyValuesPredicateEvaluator
implements PredicateEvaluator {
    private PredicateEvaluator propertyEvaluator = new JcrPropertyPredicateEvaluator();
    private PredicateEvaluator fulltextEvaluator = new FulltextPredicateEvaluator();
    private static final String OP_STARTS_WITH = "startsWith";
    private static final String OP_CONTAINS = "contains";
    protected static final String PREDICATE_BUILT_KEY = "__asset-share-commons--predicate-built";
    protected static final String PREDICATE_BUILT_VALUE = "true";
    protected static final String DELIMITER_CODE_NONE = "__NONE";
    protected static final String DELIMITER_CODE_WHITESPACE = "__WS";
    private Map<String, String> delimiterMapping = new HashMap<String, String>();
    protected Cfg cfg;
    public static final String PREDICATE_NAME = "propertyvalues";
    public static final String VALUES = "values";
    private static final String DELIMITER = "delimiter";

    protected Predicate buildPredicate(Predicate predicate) {
        if (PREDICATE_BUILT_VALUE.equals(predicate.get(PREDICATE_BUILT_KEY))) {
            return predicate;
        }
        List<String> delimiters = this.getDelimiters(predicate);
        ArrayList<String> values = new ArrayList<String>();
        PredicateEvaluatorUtil.getValues(predicate, VALUES, true).forEach(value -> values.addAll(this.getValues((String)value, delimiters)));
        if (this.isFulltextOperation(predicate)) {
            this.buildFulltextPredicate(predicate, values, predicate.get("property"));
        } else {
            this.buildPropertyPredicate(predicate, values);
        }
        predicate.set(PREDICATE_BUILT_KEY, PREDICATE_BUILT_VALUE);
        return predicate;
    }

    private void buildPropertyPredicate(Predicate propertyPredicate, List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            propertyPredicate.set(i + "_" + "value", values.get(i));
        }
        propertyPredicate.getParameters().entrySet().stream().filter(entry -> ((String)entry.getKey()).matches("^(\\d+_)?((values)|(delimiter))$")).forEach(entry -> propertyPredicate.set((String)entry.getKey(), null));
    }

    private void buildFulltextPredicate(Predicate fulltextPredicate, List<String> values, String property) {
        String operation = fulltextPredicate.get("operation");
        String queryParam = values.stream().map(StringUtils::trimToNull).filter(Objects::nonNull).filter(value -> value.length() >= 3).map(value -> this.buildFulltextValue(operation, (String)value)).collect(Collectors.joining(" OR "));
        fulltextPredicate.set("fulltext", queryParam);
        property = StringUtils.removeStart((String)property, (String)"./");
        Object[] propertySegments = StringUtils.split((String)property, (String)"/");
        int lastIndex = propertySegments.length - 1;
        propertySegments[lastIndex] = "@" + propertySegments[lastIndex];
        property = StringUtils.join((Object[])propertySegments, (String)"/");
        fulltextPredicate.set("relPath", property);
        fulltextPredicate.getParameters().entrySet().stream().filter(entry -> !((String)entry.getKey()).matches("^(\\d+_)?((fulltext)|(relPath))$")).forEach(entry -> fulltextPredicate.set((String)entry.getKey(), null));
    }

    private String buildFulltextValue(String operation, String value) {
        value = StringUtils.strip((String)value, (String)"*") + "*";
        if (!OP_STARTS_WITH.equals(operation)) {
            value = "*" + value;
        }
        return value;
    }

    private boolean isFulltextOperation(Predicate predicate) {
        return predicate.get("fulltext") != null || ArrayUtils.contains((Object[])new String[]{OP_STARTS_WITH, OP_CONTAINS}, (Object)predicate.get("operation"));
    }

    protected PredicateEvaluator getPredicateEvaluator(Predicate predicate) {
        if (this.isFulltextOperation(predicate)) {
            return this.fulltextEvaluator;
        }
        return this.propertyEvaluator;
    }

    public String getXPathExpression(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getXPathExpression(this.buildPredicate(predicate), evaluationContext);
    }

    public boolean includes(Predicate predicate, Row row, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).includes(this.buildPredicate(predicate), row, evaluationContext);
    }

    public boolean canXpath(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).canXpath(this.buildPredicate(predicate), evaluationContext);
    }

    public boolean canFilter(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).canFilter(this.buildPredicate(predicate), evaluationContext);
    }

    public boolean isFiltering(Predicate predicate, EvaluationContext evaluationContext) {
        throw new UnsupportedOperationException("isFiltering(..) is deprecated.");
    }

    public String[] getOrderByProperties(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getOrderByProperties(this.buildPredicate(predicate), evaluationContext);
    }

    public Comparator<Row> getOrderByComparator(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getOrderByComparator(this.buildPredicate(predicate), evaluationContext);
    }

    public FacetExtractor getFacetExtractor(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getFacetExtractor(this.buildPredicate(predicate), evaluationContext);
    }

    protected List<String> getValues(String data, List<String> delimiters) {
        if (delimiters.size() == 0) {
            return ImmutableList.builder().add((Object)data).build();
        }
        String regex = delimiters.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile(regex, 8);
        if (data == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(pattern.split(data)).map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected List<String> getDelimiters(Predicate predicate) {
        List<String> delimiterValues = PredicateEvaluatorUtil.getValues(predicate, DELIMITER, true);
        if (delimiterValues.stream().anyMatch(DELIMITER_CODE_NONE::equals)) {
            return Collections.emptyList();
        }
        List<String> delimiters = delimiterValues.stream().map(this::resolveDelimiter).filter(Objects::nonNull).collect(Collectors.toList());
        if (delimiters.isEmpty() && this.cfg.delimiters_default() != null) {
            return Stream.of(this.cfg.delimiters_default()).map(Pattern::quote).collect(Collectors.toList());
        }
        return delimiters;
    }

    private String resolveDelimiter(String delimiter) {
        String resolvedDelimiter = this.delimiterMapping.get(delimiter);
        if (DELIMITER_CODE_NONE.equals(delimiter)) {
            return null;
        }
        if (DELIMITER_CODE_WHITESPACE.equals(delimiter)) {
            return "\\s";
        }
        if (resolvedDelimiter != null) {
            return Pattern.quote(resolvedDelimiter);
        }
        if (delimiter != null) {
            return Pattern.quote(delimiter);
        }
        return null;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
        this.delimiterMapping = new HashMap<String, String>();
        if (cfg.delimiters_mapping() != null) {
            Arrays.stream(cfg.delimiters_mapping()).forEach(mapping -> {
                String key = StringUtils.substringBefore((String)mapping, (String)"=");
                String value = StringUtils.substringAfter((String)mapping, (String)"=");
                if (key != null) {
                    this.delimiterMapping.put(key, value);
                }
            });
        }
    }

    @ObjectClassDefinition(name="Asset Share Commons - Properties Values Predicate Evaluator")
    public static @interface Cfg {
        @AttributeDefinition(name="Default delimiter", description="The default delimiters to use when none no #_delimiter= is specified. Defaults to ','.")
        public String[] delimiters_default() default {","};

        @AttributeDefinition(name="Delimiters mapping", description="Defines custom mappings for delimiter codes to actual delimiters.")
        public String[] delimiters_mapping() default {};
    }
}

