/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionTracker;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers.AbstractRenditionDispatcherImpl;
import com.adobe.aem.commons.assetshare.util.impl.requests.ExtensionOverrideRequestWrapper;
import com.day.cq.commons.PathInfo;
import com.day.text.Text;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=-10000", "webconsole.configurationFactory.nameHint={name} [ {label} ] @ {service.ranking}"})
@Designate(ocd=Cfg.class, factory=true)
public class InternalRedirectRenditionDispatcherImpl
extends AbstractRenditionDispatcherImpl
implements AssetRenditionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(InternalRedirectRenditionDispatcherImpl.class);
    private Cfg cfg;
    private ConcurrentHashMap<String, String> mappings;
    @Reference
    private AssetRenditions assetRenditions;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile AssetRenditionTracker assetRenditionTracker;

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String getName() {
        return this.cfg.name();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.assetRenditions.getOptions(this.mappings);
    }

    @Override
    public boolean isHidden() {
        return this.cfg.hidden();
    }

    @Override
    public Set<String> getRenditionNames() {
        if (this.mappings == null) {
            return Collections.EMPTY_SET;
        }
        return this.mappings.keySet();
    }

    @Override
    public List<String> getTypes() {
        if (this.cfg.types() != null) {
            return Arrays.asList(this.cfg.types());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void dispatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        AssetRenditionParameters parameters = new AssetRenditionParameters(request);
        String expression = this.mappings.get(parameters.getRenditionName());
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            String evaluatedExpression = this.assetRenditions.evaluateExpression(request, expression);
            PathInfo pathInfo = new PathInfo(request.getResourceResolver(), evaluatedExpression);
            String resourcePath = Text.unescape((String)this.cleanPathInfoRequestPath(pathInfo.getResourcePath()));
            if (log.isTraceEnabled()) {
                log.trace("Serving internal redirect rendition [ {} ] for expression [ {} ] and resolved rendition name [ {} ]", new Object[]{resourcePath, evaluatedExpression, parameters.getRenditionName()});
            }
            if (this.assetRenditionTracker != null) {
                this.assetRenditionTracker.track((AssetRenditionDispatcher)this, request, parameters, resourcePath);
            }
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setReplaceSelectors(StringUtils.removeStart((String)pathInfo.getSelectorString(), (String)"."));
            options.setReplaceSuffix(pathInfo.getSuffix());
            request.getRequestDispatcher(resourcePath, options).include((ServletRequest)new ExtensionOverrideRequestWrapper(request, pathInfo.getExtension()), (ServletResponse)response);
        } else {
            response.sendError(404, "Could not serve asset rendition.");
        }
    }

    @Override
    public AssetRendition getRendition(AssetModel assetModel, AssetRenditionParameters parameters) {
        if (log.isWarnEnabled()) {
            log.warn("[ {} ] is not supported by the AEM Async Asset Download Framework.", (Object)this.getClass().getName());
        }
        return null;
    }

    @Override
    public boolean accepts(AssetModel assetModel, String renditionName) {
        return this.getRenditionNames().contains(renditionName);
    }

    protected String cleanPathInfoRequestPath(String resourcePath) {
        if (StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)"/")) {
            return resourcePath;
        }
        if (resourcePath.contains("://")) {
            log.debug("Resource Path [ {} ] appears to have a scheme, stripping to just the path.", (Object)resourcePath);
            return "/" + StringUtils.substringAfter((String)StringUtils.substringAfter((String)resourcePath, (String)"://"), (String)"/");
        }
        log.debug("Resource Path [ {} ] appears to be relative, changing to be absolute.", (Object)resourcePath);
        return "/" + resourcePath;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
        this.mappings = super.parseMappingsAsStrings(cfg.rendition_mappings());
    }

    @ObjectClassDefinition(name="Asset Share Commons - Rendition Dispatcher - Internal Redirect Renditions")
    public static @interface Cfg {
        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{name} [ {label} ] @ {service.ranking}";

        @AttributeDefinition(name="Name", description="The system name of this Rendition Dispatcher. This should be unique across all AssetRenditionDispatcher instances.")
        public String name() default "internal-redirect";

        @AttributeDefinition(name="Label", description="The human-friendly name of this AssetRenditionDispatcher and may be displayed to authors.")
        public String label() default "Internal Redirect Renditions";

        @AttributeDefinition(name="Rendition types", description="The types of renditions this configuration will return. Ideally all renditions in this configuration apply types specified here. This is used to drive and scope the Asset Renditions displays in Authoring datasources. OOTB types are: `image` and `video`")
        public String[] types() default {};

        @AttributeDefinition(name="Hide renditions", description="Hide if this AssetRenditionDispatcher configuration is not intended to be exposed to AEM authors for selection in dialogs.", type=AttributeType.BOOLEAN)
        public boolean hidden() default false;

        @AttributeDefinition(name="Rendition mappings", description="In the form: <renditionName>=<internal redirect url>")
        public String[] rendition_mappings() default {};

        @AttributeDefinition(name="Service ranking", description="The larger the number, the higher the precedence.", type=AttributeType.INTEGER)
        public int service_ranking() default 0;
    }
}

