/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers;

import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenditionDispatcherImpl
implements AssetRenditionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AbstractRenditionDispatcherImpl.class);
    protected static final String OSGI_PROPERTY_VALUE_DELIMITER = "=";
    public static final String QUERY_PARAM_SUGGESTED_EXTENSION = "extension";

    protected ConcurrentHashMap<String, Pattern> parseMappingsAsPatterns(String[] renditionMappings) {
        ConcurrentHashMap<String, Pattern> mappings = new ConcurrentHashMap<String, Pattern>();
        if (renditionMappings != null) {
            this.parseParameters(renditionMappings).forEach(segments -> mappings.put(StringUtils.strip((String)segments[0]), Pattern.compile(StringUtils.strip((String)segments[1]))));
        }
        return mappings;
    }

    public ConcurrentHashMap<String, String> parseMappingsAsStrings(String[] renditionMappings) {
        ConcurrentHashMap<String, String> mappings = new ConcurrentHashMap<String, String>();
        if (renditionMappings != null) {
            this.parseParameters(renditionMappings).forEach(segments -> mappings.put(StringUtils.strip((String)segments[0]), StringUtils.strip((String)segments[1])));
        }
        return mappings;
    }

    private Stream<String[]> parseParameters(String[] renditionMappings) {
        return Arrays.stream(renditionMappings).map(mapping -> StringUtils.split((String)mapping, (String)OSGI_PROPERTY_VALUE_DELIMITER, (int)2)).filter(segments -> ((String[])segments).length == 2).filter(segments -> StringUtils.isNotBlank((CharSequence)segments[0])).filter(segments -> StringUtils.isNotBlank((CharSequence)segments[1]));
    }

    public String getExtensionFromAscExtQueryParameter(String uri) throws URISyntaxException {
        String extension = new URIBuilder(uri).getQueryParams().stream().filter(nvp -> QUERY_PARAM_SUGGESTED_EXTENSION.equals(nvp.getName())).map(NameValuePair::getValue).findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)extension)) {
            extension = StringUtils.substringAfterLast((String)URI.create(uri).getPath(), (String)".");
        }
        return extension;
    }

    public String cleanURI(String uri) throws URISyntaxException {
        URIBuilder oldURI = new URIBuilder(uri);
        URIBuilder newURI = new URIBuilder(uri).removeQuery();
        oldURI.getQueryParams().stream().filter(nvp -> !QUERY_PARAM_SUGGESTED_EXTENSION.equals(nvp.getName())).forEach(nvp -> newURI.addParameter(nvp.getName(), nvp.getValue()));
        return StringUtils.replace((String)newURI.toString(), (String)"%24", (String)"$");
    }
}

