/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl;

import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="assetRenditionDispatcher", bind="bindAssetRenditionDispatcher", unbind="unbindAssetRenditionDispatcher", service=AssetRenditionDispatcher.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)})
public class AssetRenditionDispatchersImpl
implements AssetRenditionDispatchers {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionDispatchersImpl.class);
    private final RankedServices<AssetRenditionDispatcher> assetRenditionDispatchers = new RankedServices(Order.DESCENDING);

    protected void bindAssetRenditionDispatcher(AssetRenditionDispatcher service, Map<String, Object> props) {
        if (log.isDebugEnabled()) {
            log.debug("Binding AssetRenditionDispatcher [ {} ]", (Object)service.getClass().getName());
        }
        this.assetRenditionDispatchers.bind((Object)service, props);
    }

    protected void unbindAssetRenditionDispatcher(AssetRenditionDispatcher service, Map<String, Object> props) {
        if (log.isDebugEnabled()) {
            log.debug("Unbinding AssetRenditionDispatcher [ {} ]", (Object)service.getClass().getName());
        }
        this.assetRenditionDispatchers.unbind((Object)service, props);
    }

    @Override
    public List<AssetRenditionDispatcher> getAssetRenditionDispatchers() {
        if (this.assetRenditionDispatchers == null || this.assetRenditionDispatchers.getList() == null) {
            return Collections.EMPTY_LIST;
        }
        return ImmutableList.copyOf((Collection)this.assetRenditionDispatchers.getList());
    }

    @Override
    public boolean isValidAssetRenditionName(String name) {
        Optional<AssetRenditionDispatcher> found = this.getAssetRenditionDispatchers().stream().filter(dispatcher -> dispatcher.getRenditionNames().contains(name)).findAny();
        return found.isPresent();
    }
}

