/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.impl;

import com.adobe.aem.commons.assetshare.components.actions.ActionHelper;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionsDownloadOrchestrator;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionsDownloadOrchestratorManager;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionsException;
import com.adobe.aem.commons.assetshare.content.renditions.download.impl.AssetRenditionsZipperImpl;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.aem.commons.assetshare.util.ServletHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=asset-share-commons/actions/download", "sling.servlet.selectors=download-asset-renditions", "sling.servlet.extensions=zip"}, reference={@Reference(name="assetRenditionsDownloadOrchestrator", bind="bindAssetRenditionsDownloadOrchestrator", unbind="unbindAssetRenditionsDownloadOrchestrator", service=AssetRenditionsDownloadOrchestrator.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)})
public class AssetRenditionsDownloadServlet
extends SlingAllMethodsServlet
implements AssetRenditionsDownloadOrchestratorManager {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionsDownloadServlet.class);
    private static final String REQ_KEY_ASSET_PATHS = "path";
    private static final String REQ_KEY_RENDITION_NAMES = "renditionName";
    private static final String PN_ALLOWED_RENDITION_NAMES = "allowedRenditionNames";
    private static final String PN_ASSET_RENDITIONS_DOWNLOAD_ORCHESTRATOR = "assetRenditionsDownloadOrchestratorId";
    private static final String DEFAULT_ASSET_RENDITIONS_DOWNLOAD_ORCHESTRATOR = AssetRenditionsZipperImpl.class.getName();
    @Reference(target="(distribution=classic)")
    private transient RequireAem requireAem;
    @Reference
    private transient ServletHelper servletHelper;
    @Reference
    private transient ModelFactory modelFactory;
    @Reference
    private transient ActionHelper actionHelper;
    private transient Map<String, AssetRenditionsDownloadOrchestrator> assetRenditionsDownloadOrchestrators = new ConcurrentHashMap<String, AssetRenditionsDownloadOrchestrator>();

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.servletHelper.addSlingBindings(request, response);
        List<String> renditionNames = this.actionHelper.getAllowedValuesFromQueryParameter(request, REQ_KEY_RENDITION_NAMES, (String[])request.getResource().getValueMap().get(PN_ALLOWED_RENDITION_NAMES, (Object)new String[0]));
        List<AssetModel> assets = this.actionHelper.getAssetsFromQueryParameter(request, REQ_KEY_ASSET_PATHS);
        String id = this.getAssetRenditionsDownloadOrchestratorId(request);
        AssetRenditionsDownloadOrchestrator orchestrator = this.getAssetRenditionsDownloadOrchestrator(id);
        if (orchestrator == null) {
            log.warn("Invalid AssetRenditionsDownloadOrchestrator ID [ {} ]", (Object)id);
            response.setStatus(400);
            return;
        }
        try {
            orchestrator.execute(request, response, assets, renditionNames);
        }
        catch (AssetRenditionsException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getAssetRenditionsDownloadOrchestratorId(SlingHttpServletRequest request) {
        return (String)request.getResource().getValueMap().get(PN_ASSET_RENDITIONS_DOWNLOAD_ORCHESTRATOR, (Object)DEFAULT_ASSET_RENDITIONS_DOWNLOAD_ORCHESTRATOR);
    }

    @Override
    public final AssetRenditionsDownloadOrchestrator getAssetRenditionsDownloadOrchestrator(String id) {
        return this.assetRenditionsDownloadOrchestrators.get(id);
    }

    protected final void bindAssetRenditionsDownloadOrchestrator(AssetRenditionsDownloadOrchestrator service, Map<Object, Object> props) {
        String type = service.getClass().getName();
        if (type != null) {
            this.assetRenditionsDownloadOrchestrators.put(type, service);
        }
    }

    protected final void unbindAssetRenditionsDownloadOrchestrator(AssetRenditionsDownloadOrchestrator service, Map<Object, Object> props) {
        String type = service.getClass().getName();
        if (type != null) {
            this.assetRenditionsDownloadOrchestrators.remove(type);
        }
    }
}

