/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.adobe.aem.commons.assetshare.util.MimeTypeHelper;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class WebRenditionImpl
extends AbstractComputedProperty<String> {
    @Reference
    private MimeTypeHelper mimeTypeHelper;
    public static final String LABEL = "Web Rendition";
    public static final String NAME = "image";
    private Cfg cfg;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public String get(Asset asset, SlingHttpServletRequest request) {
        Rendition rendition = DamUtil.getBestFitRendition((int)1280, (List)asset.getRenditions());
        String path = "";
        if (rendition != null && this.mimeTypeHelper.isBrowserSupportedImage(rendition.getMimeType())) {
            path = rendition.getPath();
        } else if (asset.getOriginal() != null && this.mimeTypeHelper.isBrowserSupportedImage(asset.getOriginal().getMimeType())) {
            path = asset.getOriginal().getPath();
        }
        return UrlUtil.escape(path);
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Web Rendition")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Web Rendition";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"rendition"};
    }
}

