/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class ContentTypeImpl
extends AbstractComputedProperty<String> {
    public static final String LABEL = "Content Type";
    public static final String NAME = "content-type";
    private Cfg cfg;
    private static final Map<String, String> mimeTypeToLabelMap = ImmutableMap.builder().put((Object)"image/vnd.adobe.photoshop", (Object)"Photoshop").put((Object)"application/msword", (Object)"Word Doc").put((Object)"application//vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)"Word Doc").put((Object)"application/vnd.ms-excel", (Object)"Excel").put((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)"Excel").put((Object)"application/vnd.ms-powerpoint", (Object)"PowerPoint").put((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)"PowerPoint").put((Object)"application/pdf", (Object)"PDF").put((Object)"application/xml", (Object)"XML").put((Object)"application/zip", (Object)"Zip").put((Object)"application/json", (Object)"JSON").put((Object)"application/vnd.adobe.illustrator", (Object)"Illustrator").put((Object)"application/vnd.adobe.indesign", (Object)"InDesign").put((Object)"application/vnd.adobe.indesignml", (Object)"InDesign").put((Object)"application/vnd.adobe.indesignx", (Object)"InDesign").put((Object)"application/vnd.adobe.aftereffects", (Object)"After Effects").put((Object)"application/vnd.adobe.premiere", (Object)"Premiere").put((Object)"application/vnd.adobe.xd", (Object)"XD").put((Object)"text/html", (Object)"HTML").put((Object)"text/csv", (Object)"CSV").build();
    private static final Map<String, String> mimeTypePrefixToLabelMap = ImmutableMap.builder().put((Object)"image", (Object)"Image").put((Object)"video", (Object)"Video").put((Object)"audio", (Object)"Audio").put((Object)"font", (Object)"Font").put((Object)"model", (Object)"3D").put((Object)"text", (Object)"Text").build();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public String get(Asset asset) {
        String mimeType = (String)StringUtils.defaultIfBlank((CharSequence)asset.getMimeType(), (CharSequence)"");
        String value = mimeTypeToLabelMap.get(mimeType);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = mimeTypePrefixToLabelMap.get(StringUtils.substringBefore((String)mimeType, (String)"/"));
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            value = (String)StringUtils.defaultIfBlank((CharSequence)this.cfg.unknownLabel(), (CharSequence)"");
        }
        return value;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Content Type")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Content Type";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"metadata"};

        @AttributeDefinition(name="Unknown Label", description="Defaults to blank so it can be trivially handled via HTL existence checks.")
        public String unknownLabel() default "";
    }
}

