/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.impl.datasources;

import com.adobe.aem.commons.assetshare.content.properties.ComputedProperties;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.adobe.aem.commons.assetshare.util.DataSourceBuilder;
import java.util.TreeMap;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=asset-share-commons/data-sources/computed-properties", "sling.servlet.methods=GET"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class ComputedPropertiesDataSource
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ComputedPropertiesDataSource.class);
    public static final String PN_COMPUTED_PROPERTY_TYPES = "computedPropertyTypes";
    @Reference
    private transient DataSourceBuilder dataSourceBuilder;
    @Reference
    private transient ComputedProperties computedProperties;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        ValueMap properties = request.getResource().getValueMap();
        Object[] computedPropertyTypes = (String[])properties.get(PN_COMPUTED_PROPERTY_TYPES, (Object)new String[0]);
        for (ComputedProperty computedProperty : this.computedProperties.getComputedProperties()) {
            String key;
            if (!ArrayUtils.isEmpty((Object[])computedPropertyTypes) && !this.containsAny((String[])computedPropertyTypes, computedProperty.getTypes()) || !StringUtils.isNotBlank((CharSequence)(key = computedProperty.getName()))) continue;
            if (!data.containsKey(key)) {
                data.put(computedProperty.getLabel(), key);
                continue;
            }
            log.warn("Found duplicate Computed Property key [ {} ]. Only accepting the first instance.", (Object)key);
        }
        this.dataSourceBuilder.build(request, data);
    }

    private boolean containsAny(String[] arrayOne, String[] arrayTwo) {
        if (arrayOne != null && arrayTwo != null) {
            for (String valueOne : arrayOne) {
                for (String valueTwo : arrayTwo) {
                    if (!StringUtils.equals((CharSequence)valueOne, (CharSequence)valueTwo)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

