/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.impl;

import com.adobe.aem.commons.assetshare.content.MetadataProperties;
import com.day.cq.dam.commons.util.SchemaFormHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MetadataProperties.class})
@Designate(ocd=Cfg.class)
public class MetadataSchemaPropertiesImpl
implements MetadataProperties {
    private static final Logger log = LoggerFactory.getLogger(MetadataSchemaPropertiesImpl.class);
    private static final String PN_FIELD_LABEL = "fieldLabel";
    private static final String PN_NAME = "name";
    private static final String NN_FIELD = "field";
    private static final String[] RT_FIELDS = new String[]{"granite/ui/components/foundation/form/field", "granite/ui/components/coral/foundation/form/field", "dam/gui/components/admin/schemafield"};
    private static final String[] METADATA_TYPES_PROPERTIES = new String[]{"metaType", "type"};
    private Cfg cfg;

    @Override
    public Map<String, List<String>> getMetadataProperties(SlingHttpServletRequest request) {
        return this.getMetadataProperties(request, Collections.EMPTY_LIST);
    }

    @Override
    public Map<String, List<String>> getMetadataProperties(SlingHttpServletRequest request, List<String> metadataFieldResourceTypes) {
        Map<String, List<String>> collectedMetadata = new HashMap<String, List<String>>();
        Iterator resourceIterator = SchemaFormHelper.getSchemaFormsIterator((ResourceResolver)request.getResourceResolver(), (String)"/conf/global/settings/dam/adminui-extension/metadataschema", (int)0, (int)0);
        while (resourceIterator.hasNext()) {
            Resource resource = (Resource)resourceIterator.next();
            if (!((Boolean)resource.getValueMap().get("allowCustomization", (Object)true)).booleanValue()) continue;
            MetadataSchemaResourceVisitor visitor = new MetadataSchemaResourceVisitor(collectedMetadata, metadataFieldResourceTypes);
            visitor.accept(resource);
            collectedMetadata = visitor.getMetadata();
        }
        collectedMetadata = this.collectExtraMetadataProperties(collectedMetadata);
        collectedMetadata = this.removeBlacklistedMetadataProperties(collectedMetadata);
        return collectedMetadata;
    }

    protected final Map<String, List<String>> collectExtraMetadataProperties(Map<String, List<String>> collectedMetadata) {
        if (this.cfg != null && this.cfg.extra_metadata_properties() != null) {
            for (String entry : this.cfg.extra_metadata_properties()) {
                String propertyName = StringUtils.substringBefore((String)entry, (String)"=");
                String fieldLabel = StringUtils.substringAfter((String)entry, (String)"=");
                this.collectMetadataProperty(fieldLabel, propertyName, collectedMetadata);
            }
        }
        return collectedMetadata;
    }

    protected final Map<String, List<String>> removeBlacklistedMetadataProperties(Map<String, List<String>> collectedMetadata) {
        if (this.cfg != null && this.cfg.blacklisted_metadata_properties() != null) {
            for (String propertyName : this.cfg.blacklisted_metadata_properties()) {
                String withoutDotSlash = StringUtils.removeStart((String)propertyName, (String)"./");
                String withDotSlash = "./" + withoutDotSlash;
                if (collectedMetadata.containsKey(withDotSlash)) {
                    collectedMetadata.remove(withDotSlash);
                }
                if (!collectedMetadata.containsKey(withoutDotSlash)) continue;
                collectedMetadata.remove(withoutDotSlash);
            }
        }
        return collectedMetadata;
    }

    protected final void collectMetadataProperty(String fieldLabel, String propertyName, Map<String, List<String>> metadata) {
        if (StringUtils.isNotBlank((CharSequence)fieldLabel) && StringUtils.isNotBlank((CharSequence)propertyName)) {
            if (metadata.containsKey(propertyName = this.getRelativePropertyName(propertyName, metadata))) {
                List<String> tmp = metadata.get(propertyName);
                if (!tmp.contains(fieldLabel)) {
                    tmp.add(fieldLabel);
                }
                metadata.put(propertyName, tmp);
            } else {
                ArrayList<String> tmp = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)fieldLabel)) {
                    tmp.add(fieldLabel);
                }
                metadata.put(propertyName, tmp);
            }
        }
    }

    protected final String getRelativePropertyName(String propertyName, Map<String, List<String>> metadata) {
        propertyName = metadata.containsKey("./" + StringUtils.removeStart((String)propertyName, (String)"./")) ? "./" + StringUtils.removeStart((String)propertyName, (String)"./") : (metadata.containsKey(StringUtils.removeStart((String)propertyName, (String)"./")) ? StringUtils.removeStart((String)propertyName, (String)"./") : "./" + StringUtils.removeStart((String)propertyName, (String)"./"));
        return propertyName;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Metadata Schema Properties")
    static @interface Cfg {
        @AttributeDefinition(name="Extra metadata properties", description="<relative metadata property path>=<display title>")
        public String[] extra_metadata_properties() default {};

        @AttributeDefinition(name="Blacklisted metadata properties", description="<relative metadata property path>")
        public String[] blacklisted_metadata_properties() default {};
    }

    private class MetadataSchemaResourceVisitor
    extends AbstractResourceVisitor {
        private final Map<String, List<String>> metadata;
        private final List<String> metadataFieldResourceTypes;
        private boolean widget = false;

        public MetadataSchemaResourceVisitor(Map<String, List<String>> metadata, List<String> metadataFieldResourceTypes) {
            this.metadata = metadata;
            this.metadataFieldResourceTypes = new ArrayList<String>(metadataFieldResourceTypes);
        }

        public final Map<String, List<String>> getMetadata() {
            return this.metadata;
        }

        public void accept(Resource resource) {
            this.visit(resource);
            if (!this.widget) {
                this.traverseChildren(resource.listChildren());
            }
            this.widget = false;
        }

        protected void visit(Resource resource) {
            this.widget = this.isWidget(resource);
            if (!this.widget) {
                return;
            }
            ValueMap properties = resource.getValueMap();
            String fieldLabel = (String)properties.get(MetadataSchemaPropertiesImpl.PN_FIELD_LABEL, String.class);
            String propertyName = (String)properties.get(MetadataSchemaPropertiesImpl.PN_NAME, properties.get("field/name", String.class));
            MetadataSchemaPropertiesImpl.this.collectMetadataProperty(fieldLabel, propertyName, this.metadata);
        }

        private boolean isWidget(Resource widgetResource) {
            if (widgetResource == null) {
                return false;
            }
            if (this.metadataFieldResourceTypes != null && this.metadataFieldResourceTypes.size() > 0) {
                return this.metadataFieldResourceTypes.stream().anyMatch(metaType -> this.checkMetaDataType(widgetResource, (String)metaType));
            }
            return Arrays.stream(RT_FIELDS).anyMatch(resourceType -> widgetResource.isResourceType(resourceType));
        }

        private boolean checkMetaDataType(Resource widgetResource, String metaType) {
            ValueMap properties = widgetResource.getValueMap();
            for (String propertyName : METADATA_TYPES_PROPERTIES) {
                String metaTypeCandidate = (String)properties.get("granite:data/" + propertyName, properties.get(propertyName, String.class));
                if (!StringUtils.equals((CharSequence)metaType, (CharSequence)metaTypeCandidate)) continue;
                return true;
            }
            return false;
        }
    }
}

