/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CombinedProperties
implements Map<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(CombinedProperties.class);
    private static final String COMPUTED_PROPERTY_NAME_PARAMETER_DELIMITER = "?";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String PARAMETER_KEY_VALUE_DELIMITER = "=";
    private static final String UNSUPPORTED_OPERATION = "This operation is not permitted on the CombinedProperties map.";
    private final Map<String, ComputedProperty> computedProperties;
    private final Map<String, Object> cachedValues = new HashMap<String, Object>();
    private final SlingHttpServletRequest request;
    private final Asset asset;
    private ValueMap assetProperties;
    private ValueMap metaProperties;

    public CombinedProperties(List<ComputedProperty> computedProperties, SlingHttpServletRequest request, Asset asset) {
        if (log.isTraceEnabled()) {
            log.trace("Constructing CombinedProperties for [ {} ]", (Object)asset.getPath());
        }
        this.request = request;
        this.asset = asset;
        this.assetProperties = this.getProperties();
        this.metaProperties = this.getMetadataProperties();
        this.computedProperties = this.getComputedPropertiesMap(computedProperties);
    }

    @Override
    public final int size() {
        return this.computedProperties.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.computedProperties.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        ComputedPropertyParameter computedPropertyParameter = new ComputedPropertyParameter((String)key);
        boolean result = false;
        ComputedProperty computedProperty = this.computedProperties.get(computedPropertyParameter.getName());
        if (computedProperty != null && (this.cachedValues.containsKey(computedPropertyParameter.getCacheId()) || computedProperty.accepts(this.asset, this.request, computedPropertyParameter.getName()))) {
            result = true;
        }
        if (!result) {
            boolean bl = result = this.assetProperties.get((Object)computedPropertyParameter.getName()) != null;
        }
        if (!result) {
            result = this.metaProperties.get((Object)computedPropertyParameter.getName()) != null;
        }
        return result;
    }

    @Override
    public final boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Values are computed, so this cannot be determined.");
    }

    @Override
    public final Object get(Object key) {
        if (key == null) {
            return null;
        }
        ComputedPropertyParameter computedPropertyParameter = new ComputedPropertyParameter((String)key);
        if (log.isTraceEnabled()) {
            log.trace("Getting value for key [ {} ] from CombinedProperties", (Object)computedPropertyParameter.getCacheId());
        }
        if (computedPropertyParameter.getName() == null) {
            return null;
        }
        Object result = null;
        ComputedProperty computedProperty = this.computedProperties.get(computedPropertyParameter.getName());
        if (computedProperty != null) {
            if (computedProperty.isCachable() && this.cachedValues.containsKey(computedPropertyParameter.getCacheId())) {
                result = this.cachedValues.get(computedPropertyParameter.getCacheId());
                if (log.isTraceEnabled()) {
                    log.trace(String.format("Computed value [ %s -> %s ] using [ %s ] served from ComputedPropertyAccessor cache.", computedPropertyParameter.getCacheId(), result, computedProperty.getClass().getName()));
                }
            } else if (computedProperty.accepts(this.asset, this.request, computedPropertyParameter.getName())) {
                result = computedProperty.get(this.asset, this.request, computedPropertyParameter.getParameters());
                if (computedProperty.isCachable()) {
                    this.cachedValues.put(computedPropertyParameter.getCacheId(), result);
                }
                if (log.isTraceEnabled()) {
                    log.trace(String.format("Computed value [ %s -> %s ] using [ %s ] ", computedPropertyParameter.getCacheId(), result, computedProperty.getClass().getName()));
                }
            }
        }
        if (result == null && this.metaProperties != null) {
            result = this.metaProperties.get((Object)computedPropertyParameter.getName());
        }
        if (result == null && this.assetProperties != null) {
            result = this.assetProperties.get((Object)computedPropertyParameter.getName());
        }
        return result;
    }

    @Override
    public final Object put(String key, Object value) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public final void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public final Collection<Object> values() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public final Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public final boolean equals(Object o) {
        return this.computedProperties.equals(o);
    }

    @Override
    public final int hashCode() {
        return this.computedProperties.hashCode();
    }

    protected final ValueMap getProperties() {
        return ((Resource)this.asset.adaptTo(Resource.class)).getValueMap();
    }

    protected final ValueMap getMetadataProperties() {
        return ((Resource)this.asset.adaptTo(Resource.class)).getChild("jcr:content/metadata").getValueMap();
    }

    protected final Map<String, ComputedProperty> getComputedPropertiesMap(List<ComputedProperty> computedProperties) {
        HashMap<String, ComputedProperty> result = new HashMap<String, ComputedProperty>();
        for (ComputedProperty computedProperty : computedProperties) {
            String key = computedProperty.getName();
            if (!result.containsKey(key)) {
                result.put(key, computedProperty);
                if (!log.isTraceEnabled()) continue;
                log.trace("Registered ComputedProperty [ {} ] with key [ {} ]", (Object)computedProperty.getClass().getName(), (Object)key);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("ComputedProperty [ {} ] with key [ {} ] already provided by a better ranked implementation", (Object)computedProperty.getClass().getName(), (Object)key);
        }
        return result;
    }

    protected static class ComputedPropertyParameter {
        private final String name;
        private final ValueMap parameters = new ValueMapDecorator(new TreeMap());
        private String cacheId;

        public ComputedPropertyParameter(String rawParam) {
            this.name = StringUtils.substringBefore((String)rawParam, (String)CombinedProperties.COMPUTED_PROPERTY_NAME_PARAMETER_DELIMITER);
            this.parameters.putAll(ParameterUtil.toMap(StringUtils.split((String)StringUtils.substringAfter((String)rawParam, (String)CombinedProperties.COMPUTED_PROPERTY_NAME_PARAMETER_DELIMITER), (String)CombinedProperties.PARAMETER_DELIMITER), CombinedProperties.PARAMETER_KEY_VALUE_DELIMITER, true, ""));
            this.cacheId = this.name;
            if (!this.parameters.isEmpty()) {
                this.cacheId = this.cacheId + CombinedProperties.COMPUTED_PROPERTY_NAME_PARAMETER_DELIMITER + this.parameters.keySet().stream().map(key -> key + CombinedProperties.PARAMETER_KEY_VALUE_DELIMITER + (String)this.parameters.get(key, (Object)"")).collect(Collectors.joining(CombinedProperties.PARAMETER_DELIMITER));
            }
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public String getName() {
            return this.name;
        }

        public ValueMap getParameters() {
            return this.parameters;
        }
    }
}

