/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.search.impl;

import com.adobe.aem.commons.assetshare.components.search.Statistics;
import com.adobe.aem.commons.assetshare.search.Search;
import com.adobe.aem.commons.assetshare.util.ModelCache;
import com.adobe.cq.export.json.ComponentExporter;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Statistics.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/statistics"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class StatisticsImpl
implements Statistics {
    public static final String RESOURCE_TYPE = "asset-share-commons/components/search/statistics";
    @Self
    private SlingHttpServletRequest request;
    @Self
    private ModelCache modelCache;
    private Search search;
    private String id;

    @PostConstruct
    protected void init() {
        this.search = this.modelCache.get(Search.class);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = "cmp-statistics--" + String.valueOf(Math.abs(this.request.getResource().getPath().hashCode() - 1));
        }
        return this.id;
    }

    @Override
    public long getRunningTotal() {
        return this.search.getResults().getRunningTotal();
    }

    @Override
    public long getTotal() {
        return this.search.getResults().getTotal();
    }

    @Override
    public boolean hasMore() {
        return this.search.getResults().isMoreThanTotal();
    }

    @Override
    public long getTimeTaken() {
        return this.search.getResults().getTimeTaken();
    }

    @Override
    public boolean isReady() {
        return this.search != null;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

