/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.EditorLinks;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.cq.export.json.ComponentExporter;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={EditorLinks.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/editor-links"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class EditorLinksImpl
extends AbstractEmptyTextComponent
implements EditorLinks {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/editor-links";
    private static final String ASSET_DETAILS_PREFIX = "/assetdetails.html";
    private static final String ASSET_FOLDER_PREFIX = "/assets.html";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private AssetModel asset;
    @OSGiService
    @Required
    private transient RequireAem requireAem;
    @ValueMapValue
    private String assetDetailsLinkLabel;
    @ValueMapValue
    private String assetFolderLinkLabel;

    @Override
    public String getAssetDetailsEditorPath() {
        return this.request.getResourceResolver().map(ASSET_DETAILS_PREFIX + this.asset.getPath());
    }

    @Override
    public String getAssetFolderEditorPath() {
        return this.request.getResourceResolver().map((HttpServletRequest)this.request, ASSET_FOLDER_PREFIX + this.asset.getPath());
    }

    @Override
    public boolean isEmpty() {
        return !this.isReady();
    }

    @Override
    public boolean isReady() {
        boolean missingTargetResources;
        ResourceResolver resourceResolver = this.request.getResourceResolver();
        boolean publishInstance = RequireAem.ServiceType.PUBLISH.equals((Object)this.requireAem.getServiceType());
        boolean missingLabels = StringUtils.isBlank((CharSequence)this.assetDetailsLinkLabel) && StringUtils.isBlank((CharSequence)this.assetFolderLinkLabel);
        boolean bl = missingTargetResources = resourceResolver.resolve((HttpServletRequest)this.request, ASSET_DETAILS_PREFIX + this.asset.getPath()) == null || resourceResolver.resolve((HttpServletRequest)this.request, ASSET_FOLDER_PREFIX + this.asset.getPath()) == null;
        return this.asset != null && !publishInstance && !missingLabels && !missingTargetResources;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

