/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionTracker;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers.AbstractRenditionDispatcherImpl;
import com.adobe.aem.commons.assetshare.util.ExpressionEvaluator;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.cq.wcm.spi.AssetDelivery;
import com.day.cq.dam.api.Asset;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=-10000", "webconsole.configurationFactory.nameHint={name} [ {label} ] @ {service.ranking}"})
@Designate(ocd=Cfg.class, factory=true)
public class AssetDeliveryRenditionDispatcherImpl
extends AbstractRenditionDispatcherImpl
implements AssetRenditionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AssetDeliveryRenditionDispatcherImpl.class);
    private static Long PLACEHOLDER_SIZE_IN_BYTES = 0x6400000L;
    public static final String[] ALLOWED_FORMATS = new String[]{"gif", "png", "png8", "jpg", "jpeg", "jpe", "pjpg", "bjpg", "webp", "webpll", "webply"};
    public static final String PN_PATH = "path";
    public static final String PN_FORMAT = "format";
    public static final String PN_SEONAME = "seoname";
    public static final String DEFAULT_FORMAT = "webp";
    final String[] ACCEPTED_MIME_TYPES = new String[]{"image/.*", "application/pdf", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"};
    private Cfg cfg;
    private ConcurrentHashMap<String, String> mappings;
    @Reference
    private RequireAem requireAem;
    @Reference
    private AssetDelivery assetDelivery;
    @Reference
    private ModelFactory modelFactory;
    @Reference
    private ExpressionEvaluator expressionEvaluator;
    @Reference
    private AssetRenditions assetRenditions;
    @Reference
    private MimeTypeService mimeTypeService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile AssetRenditionTracker assetRenditionTracker;

    public String getLabel() {
        return this.cfg.label();
    }

    public String getName() {
        return this.cfg.name();
    }

    public Map<String, String> getOptions() {
        return this.assetRenditions.getOptions(this.mappings);
    }

    public boolean isHidden() {
        return this.cfg.hidden();
    }

    public Set<String> getRenditionNames() {
        if (this.mappings == null) {
            return Collections.EMPTY_SET;
        }
        return this.mappings.keySet();
    }

    public List<String> getTypes() {
        if (this.cfg.types() != null) {
            return Arrays.asList(this.cfg.types());
        }
        return Collections.EMPTY_LIST;
    }

    public void dispatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        AssetRenditionParameters parameters = new AssetRenditionParameters(request);
        String expression = this.mappings.get(parameters.getRenditionName());
        String renditionRedirect = this.getDeliveryURL(this.evaluateExpression(request, expression), parameters.getAsset());
        if (StringUtils.isNotBlank((CharSequence)renditionRedirect)) {
            if (log.isDebugEnabled()) {
                log.debug("Serving Asset Delivery redirect rendition [ {} ] for resolved rendition name [ {} ]", (Object)renditionRedirect, (Object)parameters.getRenditionName());
            }
            if (this.assetRenditionTracker != null) {
                this.assetRenditionTracker.track((AssetRenditionDispatcher)this, request, parameters, renditionRedirect);
            }
            if (this.cfg.redirect() == 302) {
                response.setStatus(302);
            } else {
                response.setStatus(301);
            }
            response.setHeader("Location", renditionRedirect);
        } else {
            log.error("Could not convert [ {} ] into a valid URI", (Object)renditionRedirect);
            response.sendError(404, "Could not serve asset rendition.");
        }
    }

    public AssetRendition getRendition(AssetModel assetModel, AssetRenditionParameters parameters) {
        String expression = this.mappings.get(parameters.getRenditionName());
        String renditionRedirect = this.getDeliveryURL(this.evaluateExpression(parameters.getAsset(), expression), parameters.getAsset());
        if (StringUtils.isNotBlank((CharSequence)renditionRedirect)) {
            try {
                List params = URLEncodedUtils.parse((URI)new URI(renditionRedirect), (Charset)Charset.forName("UTF-8"));
                String extension = (String)StringUtils.defaultIfBlank((CharSequence)params.stream().filter(p -> p.getName().equals(PN_FORMAT)).findFirst().map(NameValuePair::getValue).orElse(null), (CharSequence)DEFAULT_FORMAT);
                if (log.isDebugEnabled()) {
                    log.debug("Downloading Asset Delivery rendition [ {} ] for resolved rendition name [ {} ]", (Object)renditionRedirect, (Object)parameters.getRenditionName());
                }
                if (this.assetRenditionTracker != null) {
                    this.assetRenditionTracker.track((AssetRenditionDispatcher)this, assetModel, parameters, renditionRedirect);
                }
                return new AssetRendition(renditionRedirect, PLACEHOLDER_SIZE_IN_BYTES, this.mimeTypeService.getMimeType(extension));
            }
            catch (URISyntaxException e) {
                log.warn("Unable to create a valid URI for rendition redirect [ {} ]", (Object)renditionRedirect, (Object)e);
                return new AssetRendition("failed://to.create.valid.uri.from.asset.delivery.rendition.redirect", Long.valueOf(0L), "invalid/uri");
            }
        }
        return null;
    }

    public boolean accepts(AssetModel assetModel, String renditionName) {
        if (this.assetDelivery == null) {
            return false;
        }
        if (!this.getRenditionNames().contains(renditionName)) {
            return false;
        }
        String assetFormat = StringUtils.lowerCase((String)((String)assetModel.getProperties().get("dc:format", String.class)));
        return Arrays.stream(this.ACCEPTED_MIME_TYPES).anyMatch(regex -> assetFormat.matches((String)regex));
    }

    protected String evaluateExpression(SlingHttpServletRequest request, String expression) {
        Asset asset = (Asset)request.getResource().adaptTo(Asset.class);
        return this.evaluateExpression(asset, expression);
    }

    protected String evaluateExpression(Asset asset, String expression) {
        AssetModel assetModel = (AssetModel)this.modelFactory.createModel(asset.adaptTo(Resource.class), AssetModel.class);
        expression = this.expressionEvaluator.evaluateAssetExpression(expression, assetModel);
        expression = this.expressionEvaluator.evaluateProperties(expression, assetModel);
        return expression;
    }

    protected String getDeliveryURL(String expression, Asset asset) {
        Map map = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)expression);
        Map<String, Object> params = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        if (StringUtils.isBlank((CharSequence)((String)params.get(PN_PATH)))) {
            params.put(PN_PATH, asset.getPath());
        }
        if (StringUtils.isBlank((CharSequence)((String)params.get(PN_FORMAT))) || !ArrayUtils.contains((Object[])ALLOWED_FORMATS, (Object)params.get(PN_FORMAT))) {
            params.put(PN_FORMAT, DEFAULT_FORMAT);
        }
        if (StringUtils.isBlank((CharSequence)((String)params.get(PN_SEONAME)))) {
            if (StringUtils.isNotBlank((CharSequence)asset.getMetadataValue("dc:title"))) {
                params.put(PN_SEONAME, asset.getMetadataValue("dc:title").replaceAll("[^a-zA-Z0-9]", "-"));
            } else if (StringUtils.isNotBlank((CharSequence)asset.getName())) {
                params.put(PN_SEONAME, asset.getName().replaceAll("[^a-zA-Z0-9]", "-"));
            } else {
                params.put(PN_SEONAME, "asset");
            }
        }
        return this.assetDelivery.getDeliveryURL((Resource)asset.adaptTo(Resource.class), params);
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
        this.mappings = super.parseMappingsAsStrings(cfg.rendition_mappings());
    }

    @ObjectClassDefinition(name="Asset Share Commons - Rendition Dispatcher - Asset Delivery Renditions")
    public static @interface Cfg {
        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{name} [ {label} ] @ {service.ranking}";

        @AttributeDefinition(name="Name", description="The system name of this Rendition Dispatcher. This should be unique across all AssetRenditionDispatcher instances.")
        public String name() default "aem-asset-delivery-redirect";

        @AttributeDefinition(name="Label", description="The human-friendly name of this AssetRenditionDispatcher and may be displayed to authors.")
        public String label() default "Web-optimized Renditions";

        @AttributeDefinition(name="Rendition types", description="The types of renditions this configuration will return. Ideally all renditions in this configuration apply types specified here. This is used to drive and scope the Asset Renditions displays in Authoring datasources. OOTB types are: `image` and `video`")
        public String[] types() default {};

        @AttributeDefinition(name="Hide renditions", description="Hide if this AssetRenditionDispatcher configuration is not intended to be exposed to AEM authors for selection in dialogs.", type=AttributeType.BOOLEAN)
        public boolean hidden() default false;

        @AttributeDefinition(name="Redirect", description="Select the type of redirect that should be made: Moved Permanently (301) or Moved Temporarily (302). Defaults to 301.", options={@Option(label="Moved Permanently (301)", value="301"), @Option(label="Moved Temporarily (302)", value="302")})
        public int redirect() default 301;

        @AttributeDefinition(name="Rendition mappings", description="In the form: <rendition name>=<delivery parameters> -- Example delivery parameters: format=webp&preferwebp=true&width=98&quality=50")
        public String[] rendition_mappings() default {};

        @AttributeDefinition(name="Service ranking", description="The larger the number, the higher the precedence.", type=AttributeType.INTEGER)
        public int service_ranking() default 0;
    }
}

