/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.async.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.content.renditions.download.DownloadExtensionResolver;
import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadArchiveNamer;
import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadTargetParameters;
import com.adobe.cq.dam.download.api.DownloadTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"service.ranking:Integer=-10000"})
public class ExpressionDownloadArchiveNamer
implements DownloadArchiveNamer {
    @Reference
    private AssetRenditions assetRenditions;
    @Reference
    private MimeTypeService mimeTypeService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile DownloadExtensionResolver downloadExtensionResolver;

    @Override
    public String getArchiveFilePath(AssetModel assetModel, AssetRendition assetRendition, DownloadTarget downloadTarget) {
        String expression;
        ResourceResolver resourceResolver = assetModel.getResource().getResourceResolver();
        Resource downloadComponentResource = resourceResolver.getResource((String)downloadTarget.getParameter(DownloadTargetParameters.DOWNLOAD_COMPONENT_PATH.toString(), String.class));
        String renditionName = (String)downloadTarget.getParameter(DownloadTargetParameters.RENDITION_NAME.toString(), String.class);
        if (downloadComponentResource == null || renditionName == null) {
            return null;
        }
        String extension = this.resolveDownloadExtension(assetModel, assetRendition);
        if (extension == null && StringUtils.isNotBlank((CharSequence)assetRendition.getMimeType())) {
            extension = this.mimeTypeService.getExtension(assetRendition.getMimeType());
        }
        if (StringUtils.isNotBlank((CharSequence)extension) && !StringUtils.startsWith((CharSequence)extension, (CharSequence)".")) {
            extension = "." + extension;
        }
        if (StringUtils.isNotBlank((CharSequence)(expression = (String)downloadComponentResource.getValueMap().get("archiveFileExpression", (Object)"${asset.name.no-extension}/${asset.name.no-extension} (${rendition.name})")))) {
            return this.assetRenditions.evaluateExpression(assetModel, renditionName, expression) + (String)StringUtils.defaultIfBlank((CharSequence)extension, (CharSequence)"");
        }
        return null;
    }

    private String resolveDownloadExtension(AssetModel assetModel, AssetRendition assetRendition) {
        if (this.downloadExtensionResolver != null) {
            return this.downloadExtensionResolver.resolve(assetModel, assetRendition);
        }
        return null;
    }
}

