/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.downloads.impl;

import com.adobe.aem.commons.assetshare.components.actions.ActionHelper;
import com.adobe.aem.commons.assetshare.components.actions.downloads.Downloads;
import com.adobe.aem.commons.assetshare.components.actions.downloads.impl.PlaceholderDownloadEntry;
import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadEntry;
import com.adobe.aem.commons.assetshare.content.renditions.download.async.impl.DownloadEntryImpl;
import com.adobe.cq.dam.download.api.DownloadException;
import com.adobe.cq.dam.download.api.DownloadProgress;
import com.adobe.cq.dam.download.api.DownloadService;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.WCMMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Downloads.class}, resourceType={"asset-share-commons/components/modals/downloads"})
@Exporter(name="jackson", extensions={"json"})
public class DownloadsImpl
implements Downloads,
ComponentExporter {
    private static final Logger log = LoggerFactory.getLogger(DownloadsImpl.class);
    static final String RESOURCE_TYPE = "asset-share-commons/components/modals/downloads";
    private static final String REQ_PARAM_DOWNLOAD_IDS = "downloadId";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @SlingObject
    @Required
    private ResourceResolver resourceResolver;
    @OSGiService
    private ActionHelper actionHelper;
    @OSGiService
    private DownloadService downloadService;
    private List<DownloadEntry> activeDownloads = null;

    @Override
    public List<DownloadEntry> getDownloads() throws DownloadException {
        if (this.activeDownloads == null) {
            this.activeDownloads = new ArrayList<DownloadEntry>();
            List<String> allowedDownloadIds = this.getAllowedDownloadIds(this.request);
            Calendar now = Calendar.getInstance();
            this.activeDownloads = StreamSupport.stream(this.downloadService.getDownloadIds(this.resourceResolver).spliterator(), false).filter(id -> allowedDownloadIds.contains(id)).map(id -> {
                try {
                    DownloadProgress downloadProgress = this.downloadService.getProgress(id, this.resourceResolver);
                    if (downloadProgress != null) {
                        return new DownloadEntryImpl(this.request, (String)id, downloadProgress);
                    }
                    return null;
                }
                catch (DownloadException e) {
                    if (log.isWarnEnabled()) {
                        log.warn("Unable to get async DownloadProgress for downloadId [ {} ] for user [ {} ]", new Object[]{id, this.resourceResolver.getUserID(), e});
                    }
                    return null;
                }
            }).filter(Objects::nonNull).filter(downloadEntry -> {
                if (downloadEntry.getFinished() == null) {
                    return true;
                }
                return Duration.between(downloadEntry.getFinished().toInstant(), now.toInstant()).abs().toHours() <= 1L;
            }).collect(Collectors.toList());
            if (StringUtils.isBlank((CharSequence)this.request.getRequestPathInfo().getSelectorString()) && (WCMMode.EDIT.equals((Object)WCMMode.fromRequest((ServletRequest)this.request)) || WCMMode.PREVIEW.equals((Object)WCMMode.fromRequest((ServletRequest)this.request)))) {
                this.activeDownloads.add(new PlaceholderDownloadEntry(this.request, "01-02", DownloadProgress.Status.PROCESSING, 2));
                this.activeDownloads.add(new PlaceholderDownloadEntry(this.request, "02-03", DownloadProgress.Status.SUCCESSFUL, 3));
                this.activeDownloads.add(new PlaceholderDownloadEntry(this.request, "04-05", DownloadProgress.Status.PARTIALLY_SUCCESSFUL, 4));
                this.activeDownloads.add(new PlaceholderDownloadEntry(this.request, "06-07", DownloadProgress.Status.FAILED, 2));
            }
        }
        return Collections.unmodifiableList(this.activeDownloads);
    }

    private List<String> getAllowedDownloadIds(SlingHttpServletRequest request) {
        RequestParameter[] requestParameters = request.getRequestParameters(REQ_PARAM_DOWNLOAD_IDS);
        if (requestParameters != null) {
            return Arrays.stream(requestParameters).map(rp -> rp.getString()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

