/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.project.model;

import com.adobe.aem.project.ServiceType;
import com.adobe.aem.project.model.Application;
import com.adobe.aem.project.model.ArtifactsFile;
import com.adobe.aem.project.model.ConfigurationFile;
import com.adobe.aem.project.model.FeatureParticipantResolver;
import com.adobe.aem.project.model.Module;
import com.adobe.aem.project.model.ModuleType;
import com.adobe.aem.project.model.RepoinitFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;

public class Project
implements FeatureParticipantResolver,
Serializable {
    private final List<Module> modules = new ArrayList<Module>();
    private final File rootDirectory;
    private Application application;

    public Project(File rootDir) {
        this.rootDirectory = rootDir;
    }

    public void scan() {
        for (File f : this.getRootDirectory().listFiles()) {
            Module m;
            if (!f.isDirectory()) continue;
            if ("application".equals(f.getName())) {
                this.setApplication(new Application(f));
                continue;
            }
            if (f.getName().startsWith("bundle_")) {
                m = new Module(f);
                m.setType(ModuleType.BUNDLE);
                this.getModules().add(m);
                continue;
            }
            if (!f.getName().startsWith("content_")) continue;
            m = new Module(f);
            m.setType(ModuleType.CONTENT);
            this.getModules().add(m);
        }
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @Override
    public ConfigurationFile getSource(Configuration cfg, ServiceType serviceType, ArtifactId origin) {
        for (Module m : this.getModules()) {
            if (!m.getId().changeClassifier(null).isSame(origin)) continue;
        }
        if (this.getApplication() != null && this.getApplication().getId().equals((Object)origin)) {
            for (ConfigurationFile current : this.getApplication().getConfigurationFiles()) {
                if (!current.getPid().equals(cfg.getPid()) || serviceType != current.getServiceType()) continue;
                return current;
            }
            if (serviceType != null) {
                return this.getSource(cfg, null, origin);
            }
        }
        return null;
    }

    @Override
    public ArtifactsFile getSource(ArtifactId artifactId, ServiceType serviceType, ArtifactId origin) {
        for (Module m : this.getModules()) {
            if (!m.getId().changeClassifier(null).isSame(origin)) continue;
        }
        if (this.getApplication() != null && this.getApplication().getId().equals((Object)origin)) {
            ArtifactsFile file;
            for (ArtifactsFile current : this.getApplication().getBundleFiles()) {
                if (current.getServiceType() != serviceType || (file = this.getSource(artifactId, serviceType, current)) == null) continue;
                return file;
            }
            for (ArtifactsFile current : this.getApplication().getContentPackageFiles()) {
                file = this.getSource(artifactId, serviceType, current);
                if (current.getServiceType() != serviceType || file == null) continue;
                return file;
            }
            if (serviceType != null) {
                return this.getSource(artifactId, null, origin);
            }
        }
        return null;
    }

    private ArtifactsFile getSource(ArtifactId artifactId, ServiceType serviceType, ArtifactsFile artifacts) {
        try {
            for (Artifact a : artifacts.readArtifacts()) {
                if (!a.getId().isSame(artifactId)) continue;
                return artifacts;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public RepoinitFile getSource(ServiceType serviceType, ArtifactId origin) {
        if (this.getApplication() != null && this.getApplication().getId().equals((Object)origin)) {
            return null;
        }
        return null;
    }
}

