/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.project.model;

import com.adobe.aem.project.ServiceType;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Files;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;

public final class ArtifactsFile
implements Serializable {
    private ServiceType serviceType;
    private transient Artifacts artifacts;
    private final File source;
    private final FileType type;

    public ArtifactsFile(FileType type, File source) {
        this.source = source;
        this.type = type;
    }

    public FileType getFileType() {
        return this.type;
    }

    public File getSource() {
        return this.source;
    }

    public void resetArtifacts() {
        this.artifacts = null;
    }

    public Artifacts getArtifacts() {
        return this.artifacts;
    }

    private String getFeatureJson(String contents) {
        if (this.type == FileType.CONTENT_PACKAGES) {
            return "{ \"id\":\"g:a:1\",\"content-packages:ARTIFACTS|true\": ".concat(contents).concat("}");
        }
        return "{ \"id\":\"g:a:1\",\"bundles\": ".concat(contents).concat("}");
    }

    public Artifacts readArtifacts() throws IOException {
        if (this.artifacts == null) {
            String contents = Files.readString(this.source.toPath());
            String featureJson = this.getFeatureJson(contents);
            Feature f = FeatureJSONReader.read((Reader)new StringReader(featureJson), (String)this.source.getAbsolutePath());
            if (this.type == FileType.CONTENT_PACKAGES) {
                Extension ext = f.getExtensions().getByName("content-packages");
                this.artifacts = ext.getArtifacts();
            } else {
                this.artifacts = f.getBundles();
            }
        }
        return this.artifacts;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public static enum FileType {
        BUNDLES,
        CONTENT_PACKAGES;

    }
}

