/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.tasks;

import com.adobe.aem.analyser.result.AemAnalyserAnnotation;
import com.adobe.aem.analyser.result.AemAnalyserResult;
import com.adobe.aem.analyser.tasks.ConfigurationsTaskConfig;
import com.adobe.aem.analyser.tasks.TaskContext;
import com.adobe.aem.project.RunModes;
import com.adobe.aem.project.ServiceType;
import com.adobe.aem.project.model.ConfigurationFile;
import com.adobe.aem.project.model.ConfigurationFileType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.Region;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidator;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationsTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationsTaskConfig taskConfig;
    private final TaskContext context;

    public ConfigurationsTask(TaskContext context, ConfigurationsTaskConfig config) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(config);
        this.taskConfig = config;
        this.context = context;
    }

    public List<ConfigurationFile> scanRepositoryDirectory(File directory) throws IOException {
        ArrayList<ConfigurationFile> result = new ArrayList<ConfigurationFile>();
        if (directory.exists()) {
            this.context.checkProjectFile(directory);
            this.logger.debug("Scanning {}", (Object)this.context.getRelativePath(directory));
            for (String rootDir : new String[]{"libs", "apps"}) {
                File dir = new File(directory, rootDir);
                if (!dir.exists()) continue;
                this.scanRepositoryForConfigFolders(result, dir, "apps".equals(rootDir) ? ConfigurationFile.Location.APPS : ConfigurationFile.Location.LIBS);
            }
        } else {
            this.logger.debug("Configured repository directory does not exist: {}", (Object)directory.getAbsolutePath());
        }
        return result;
    }

    public AemAnalyserResult analyseConfigurations(List<ConfigurationFile> configFiles) throws IOException {
        AemAnalyserResult result = new AemAnalyserResult();
        if (configFiles.isEmpty()) {
            this.logger.info("No configurations found in project");
        } else {
            this.logger.debug("{} configurations found in project", (Object)configFiles.size());
            ArtifactId customFeatureId = this.context.getProjectId().changeClassifier("custom").changeType("slingosgifeature");
            Feature customFeature = new Feature(customFeatureId);
            ArtifactId productFeatureId = customFeatureId.changeClassifier("product");
            Map<ServiceType, ConfigurationApi> productApis = this.loadConfigurationApis(customFeatureId, productFeatureId);
            ConfigurationApi customApi = new ConfigurationApi();
            customApi.getFeatureToRegionCache().put(customFeatureId, Region.GLOBAL);
            customApi.getFeatureToRegionCache().put(productFeatureId, Region.INTERNAL);
            customApi.setRegion(Region.GLOBAL);
            ConfigurationApi.setConfigurationApi((Feature)customFeature, (ConfigurationApi)customApi);
            for (ConfigurationFile file : configFiles) {
                this.analyseConfigFile(file, result, productApis, customFeature, productFeatureId);
            }
        }
        return result;
    }

    private Map<ServiceType, ConfigurationApi> loadConfigurationApis(ArtifactId customFeatureId, ArtifactId productFeatureId) throws IOException {
        HashMap<ServiceType, ConfigurationApi> result = new HashMap<ServiceType, ConfigurationApi>();
        for (Map.Entry<ServiceType, Feature> entry : this.context.getProductFeatures().entrySet()) {
            ConfigurationApi api = ConfigurationApi.getConfigurationApi((Feature)entry.getValue());
            if (api == null) continue;
            api.setRegion(Region.GLOBAL);
            api.getFeatureToRegionCache().put(customFeatureId, Region.GLOBAL);
            api.getFeatureToRegionCache().put(productFeatureId, Region.INTERNAL);
            result.put(entry.getKey(), api);
        }
        return result;
    }

    private void scanRepositoryForConfigFolders(List<ConfigurationFile> configFiles, File dir, ConfigurationFile.Location location) throws IOException {
        this.logger.debug("Scanning for configuration folders in {}", (Object)this.context.getRelativePath(dir));
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            String runMode = this.isConfigFolder(f);
            if (runMode != null) {
                this.scanConfigurationFolder(configFiles, f, runMode, location, 1);
                continue;
            }
            this.scanRepositoryForConfigFolders(configFiles, f, location);
        }
    }

    private void scanConfigurationFolder(List<ConfigurationFile> configFiles, File dir, String runMode, ConfigurationFile.Location location, int level) throws IOException {
        this.logger.debug("Scanning for configurations in {}", (Object)this.context.getRelativePath(dir));
        for (File f : dir.listFiles()) {
            ConfigurationFileType type;
            if (f.isDirectory()) {
                this.scanConfigurationFolder(configFiles, f, runMode, location, level + 1);
                continue;
            }
            if (f.getName().startsWith(".") || (type = ConfigurationFileType.fromFileName(f.getName())) == null) continue;
            ConfigurationFile file = new ConfigurationFile(location, f, type);
            file.setLevel(level);
            file.setRunMode(runMode.isEmpty() ? null : runMode);
            configFiles.add(file);
        }
    }

    private String isConfigFolder(File dir) {
        String name = dir.getName();
        if ("config".equals(name) || "install".equals(name)) {
            return "";
        }
        if (name.startsWith("install.")) {
            return name.substring(8);
        }
        if (name.startsWith("config.")) {
            return name.substring(7);
        }
        return null;
    }

    private boolean checkRunMode(ConfigurationFile file, AemAnalyserResult result) throws IOException {
        boolean validRunMode = RunModes.isRunModeAllowedIncludingSDK(file.getRunMode());
        if (!validRunMode) {
            String validMode = RunModes.checkIfRunModeIsSpecifiedInWrongOrder(file.getRunMode());
            if (validMode != null) {
                result.getErrors().add(new AemAnalyserAnnotation(file.getSource(), "Configuration has invalid runmode: ".concat(file.getRunMode()).concat(". Please use this runmode instead: ").concat(validMode)));
            } else {
                result.getErrors().add(new AemAnalyserAnnotation(file.getSource(), "Configuration has unused runmode: ".concat(file.getRunMode())));
            }
        }
        return validRunMode;
    }

    private void analyseConfigFile(ConfigurationFile file, AemAnalyserResult result, Map<ServiceType, ConfigurationApi> productApis, Feature customFeature, ArtifactId productFeatureId) throws IOException {
        Dictionary<String, Object> properties;
        this.logger.debug("Analysing file ".concat(this.context.getRelativePath(file.getSource())));
        if (this.taskConfig.isEnforceRepositoryConfigurationBelowConfigFolder() && file.getLevel() > 1) {
            result.getErrors().add(new AemAnalyserAnnotation(file.getSource(), "Configuration must be directly inside a configuration folder and not in a sub folder."));
        }
        if (file.getLocation() == ConfigurationFile.Location.LIBS) {
            result.getErrors().add(new AemAnalyserAnnotation(file.getSource(), "Configuration must be inside the apps folder (not libs)."));
        }
        if (this.checkRunMode(file, result) && (properties = file.readConfiguration()) != null) {
            if (file.getType() != ConfigurationFileType.JSON) {
                result.getWarnings().add(new AemAnalyserAnnotation(file.getSource(), "Configuration is not in JSON format. Please convert."));
            }
            for (ServiceType serviceType : this.context.getProductFeatures().keySet()) {
                if (!RunModes.matchesRunMode(serviceType, file.getRunMode())) continue;
                Feature feature = this.context.getProductFeatures().get((Object)serviceType);
                ConfigurationApi api = productApis.get((Object)serviceType);
                if (api == null) continue;
                Configuration cfg = new Configuration(file.getPid());
                cfg.setFeatureOrigins(Collections.singletonList(customFeature.getId()));
                ConfigurableEntity entity = cfg.isFactoryConfiguration() ? (ConfigurableEntity)api.getFactoryConfigurationDescriptions().get(cfg.getFactoryPid()) : (ConfigurableEntity)api.getConfigurationDescriptions().get(cfg.getPid());
                if (entity == null) continue;
                Configuration featureCfg = feature.getConfigurations().getConfiguration(file.getPid());
                if (featureCfg != null) {
                    for (String propName : Collections.list(featureCfg.getConfigurationProperties().keys())) {
                        cfg.getProperties().put(propName, featureCfg.getProperties().get(propName));
                        cfg.setFeatureOrigins(propName, Collections.singletonList(productFeatureId));
                    }
                }
                for (String propName : Collections.list(properties.keys())) {
                    cfg.getProperties().put(propName, properties.get(propName));
                    cfg.setFeatureOrigins(propName, Collections.singletonList(customFeature.getId()));
                }
                customFeature.getConfigurations().add((Object)cfg);
                this.validateConfiguration(file, customFeature, api, result);
                customFeature.getConfigurations().remove((Object)cfg);
            }
        }
    }

    private void validateConfiguration(ConfigurationFile file, Feature customFeature, ConfigurationApi api, AemAnalyserResult result) throws IOException {
        FeatureValidator validator = new FeatureValidator();
        FeatureValidationResult featureResult = validator.validate(customFeature, api);
        ConfigurationValidationResult cfgResult = (ConfigurationValidationResult)featureResult.getConfigurationResults().get(file.getPid());
        for (String string : cfgResult.getWarnings()) {
            result.getWarnings().add(new AemAnalyserAnnotation(file.getSource(), string));
        }
        for (String string : cfgResult.getErrors()) {
            result.getErrors().add(new AemAnalyserAnnotation(file.getSource(), string));
        }
        for (Map.Entry entry : cfgResult.getPropertyResults().entrySet()) {
            for (String warn : ((PropertyValidationResult)entry.getValue()).getWarnings()) {
                result.getWarnings().add(new AemAnalyserAnnotation(file.getSource(), "Property ".concat((String)entry.getKey()).concat(" - ").concat(warn)));
            }
            for (String err : ((PropertyValidationResult)entry.getValue()).getErrors()) {
                result.getErrors().add(new AemAnalyserAnnotation(file.getSource(), "Property ".concat((String)entry.getKey()).concat(" - ").concat(err)));
            }
        }
    }
}

