/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.result;

import java.io.File;
import java.util.Objects;

public class AemAnalyserAnnotation {
    private final File source;
    private final long lineNumber;
    private final long columnNumber;
    private final String message;

    public AemAnalyserAnnotation(String message) {
        this(null, message);
    }

    public AemAnalyserAnnotation(File source, String message) {
        this(source, message, -1L, -1L);
    }

    public AemAnalyserAnnotation(File source, String message, long lnr, long cnr) {
        this.source = source;
        this.message = message;
        this.lineNumber = lnr;
        this.columnNumber = cnr;
    }

    public File getSource() {
        return this.source;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public long getColumnNumber() {
        return this.columnNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.getSource() == null) {
            return this.getMessage();
        }
        String location = null;
        if (this.getLineNumber() != -1L) {
            location = this.getColumnNumber() != -1L ? "[".concat(String.valueOf(this.getLineNumber())).concat(":").concat(String.valueOf(this.getColumnNumber())).concat("]") : "[".concat(String.valueOf(this.getLineNumber())).concat("]");
        }
        return this.getSource().getAbsolutePath().concat(location == null ? "" : location).concat(": ").concat(this.getMessage());
    }

    public String toString(File rootDirectory) {
        if (this.getSource() == null) {
            return this.getMessage();
        }
        String location = "";
        if (this.getLineNumber() != -1L) {
            location = this.getColumnNumber() != -1L ? " [".concat(String.valueOf(this.getLineNumber())).concat(":").concat(String.valueOf(this.getColumnNumber())).concat("]") : " [".concat(String.valueOf(this.getLineNumber())).concat("]");
        }
        String file = this.getSource().getAbsolutePath().substring(rootDirectory.getAbsolutePath().length() + 1);
        return file.concat(location).concat(": ").concat(this.getMessage());
    }

    public String toMessage(Level level, File rootDirectory) {
        String prefix = "::".concat(level.name()).concat(" ");
        String postfix = "::".concat(this.getMessage());
        if (this.getSource() == null) {
            return prefix.concat(postfix);
        }
        String location = this.getLineNumber() != -1L ? (this.getColumnNumber() != -1L ? ",line=".concat(String.valueOf(this.getLineNumber())).concat(",col=").concat(String.valueOf(this.getColumnNumber())) : ",line=".concat(String.valueOf(this.getLineNumber()))) : "";
        String file = this.getSource().getAbsolutePath().substring(rootDirectory.getAbsolutePath().length() + 1);
        return prefix.concat("file=").concat(file).concat(location).concat(postfix);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.lineNumber, this.columnNumber, this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AemAnalyserAnnotation)) {
            return false;
        }
        AemAnalyserAnnotation other = (AemAnalyserAnnotation)obj;
        return Objects.equals(this.source, other.source) && this.lineNumber == other.lineNumber && this.columnNumber == other.columnNumber && Objects.equals(this.message, other.message);
    }

    public static enum Level {
        error,
        warning;

    }
}

