/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.AemAnalyserUtil;
import com.adobe.aem.analyser.UserFeatureAggregator;
import com.adobe.aem.project.ServiceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.sling.feature.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunmodeMappingUserFeatureAggregator
implements UserFeatureAggregator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File featureInputDirectory;

    public RunmodeMappingUserFeatureAggregator(File featureInputDirectory) {
        this.featureInputDirectory = featureInputDirectory;
    }

    @Override
    public Map<String, List<Feature>> getUserAggregates(Map<String, Feature> projectFeatures, EnumSet<ServiceType> serviceTypes, Map<String, String> additionalRunmodes) throws IOException {
        Properties runmodeProps = this.getRunmodeMappings();
        HashMap<String, List<Feature>> aggregates = new HashMap<String, List<Feature>>();
        Map<String, String> rmp = runmodeProps.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        Map<String, List<String>> toCreate = this.getUserAggregatesToCreate(rmp, serviceTypes, additionalRunmodes);
        for (Map.Entry<String, List<String>> entry : toCreate.entrySet()) {
            String name = "user-aggregated-".concat(entry.getKey());
            this.logger.info("For aggregate {} got entries {}", (Object)name, entry.getValue());
            List list = aggregates.computeIfAbsent(name, n -> new ArrayList());
            entry.getValue().forEach(n -> list.add((Feature)projectFeatures.get(n)));
        }
        return aggregates;
    }

    private Properties getRunmodeMappings() throws IOException {
        File mappingFile = new File(this.featureInputDirectory, "runmode.mapping");
        if (!mappingFile.isFile()) {
            throw new IOException("File generated by content package to feature model converter not found: " + mappingFile);
        }
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(mappingFile);){
            p.load(is);
        }
        return p;
    }

    private Map<String, List<String>> getUserAggregatesToCreate(Map<String, String> runmodeProps, EnumSet<ServiceType> serviceTypes, Map<String, String> additionalRunmodes) throws IOException {
        try {
            return AemAnalyserUtil.getAggregates(runmodeProps, serviceTypes, additionalRunmodes);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
    }
}

