/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.AemAnalyser;
import com.adobe.aem.project.EnvironmentType;
import com.adobe.aem.project.RunModes;
import com.adobe.aem.project.ServiceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class AemAnalyserUtil {
    static final Set<String> ALL_USED_MODES = Stream.concat(RunModes.AUTHOR_ONLY_MODES.stream(), RunModes.PUBLISH_ONLY_MODES.stream()).collect(Collectors.toSet());
    private static final String DEFAULT_MODE = "(default)";

    static Set<String> getUsedModes(EnumSet<ServiceType> st) {
        if (st.size() == 0) {
            throw new IllegalStateException("No service type specified");
        }
        if (st.size() == 1) {
            switch ((ServiceType)((Object)st.iterator().next())) {
                case AUTHOR: {
                    return RunModes.AUTHOR_ONLY_MODES;
                }
                case PUBLISH: {
                    return RunModes.PUBLISH_ONLY_MODES;
                }
            }
        }
        return ALL_USED_MODES;
    }

    static String getValidRunMode(String mode) {
        return RunModes.checkIfRunModeIsSpecifiedInWrongOrder(mode);
    }

    public static boolean isRunModeUsed(String mode, EnumSet<ServiceType> serviceTypes) {
        return AemAnalyserUtil.getUsedModes(serviceTypes).contains(mode);
    }

    public static Map<String, List<String>> getAggregates(Map<String, String> runmodeProps, EnumSet<ServiceType> serviceTypes) {
        return AemAnalyserUtil.getAggregates(runmodeProps, serviceTypes, Collections.emptyMap());
    }

    public static Map<String, List<String>> getAggregates(Map<String, String> runmodeProps, EnumSet<ServiceType> serviceTypes, Map<String, String> additionalRunmodes) {
        HashMap<String, String> rmp = new HashMap<String, String>(runmodeProps);
        Map<String, List<String>> result = AemAnalyserUtil.primeResultWithDefault(rmp, serviceTypes);
        for (String mode : AemAnalyserUtil.sortPropertyNames(rmp.keySet())) {
            List<String> models = result.get(mode);
            boolean valid = false;
            if (models != null) {
                String[] sources;
                for (String pck : sources = rmp.get(mode).split(",")) {
                    models.add(pck);
                }
                EnvironmentType[] environmentTypeArray = EnvironmentType.values();
                int n = environmentTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    EnvironmentType et = environmentTypeArray[i];
                    String key = mode + "." + et.asString();
                    List<String> subModels = result.get(key);
                    if (subModels == null) continue;
                    for (String pck : sources) {
                        subModels.add(pck);
                    }
                }
                valid = true;
            } else {
                for (ServiceType sp : ServiceType.values()) {
                    String key = sp.asString() + "." + mode;
                    models = result.get(key);
                    if (models == null) continue;
                    for (String pck : rmp.get(mode).split(",")) {
                        models.add(pck);
                    }
                    valid = true;
                }
            }
            if (!valid) continue;
            rmp.remove(mode);
        }
        AemAnalyserUtil.handleAdditionalRunmodes(rmp, serviceTypes, additionalRunmodes, result);
        AemAnalyserUtil.reportUnhandledModes(rmp);
        AemAnalyserUtil.pruneModels(result, additionalRunmodes.keySet());
        return result;
    }

    private static Map<String, List<String>> primeResultWithDefault(Map<String, String> runmodeProps, EnumSet<ServiceType> serviceTypes) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String mode : AemAnalyserUtil.getUsedModes(serviceTypes)) {
            result.put(mode, new ArrayList());
        }
        String defaultFm = runmodeProps.remove(DEFAULT_MODE);
        if (defaultFm != null) {
            for (String pck : defaultFm.toString().split(",")) {
                result.values().stream().forEach(s -> s.add(pck));
            }
        }
        return result;
    }

    private static void handleAdditionalRunmodes(Map<String, String> runmodeProps, EnumSet<ServiceType> serviceTypes, Map<String, String> additionalRunmodes, Map<String, List<String>> result) {
        for (Map.Entry<String, String> addEntry : additionalRunmodes.entrySet()) {
            String newMode = addEntry.getKey();
            String baseMode = addEntry.getValue();
            for (ServiceType st : serviceTypes) {
                String bmKey = st.asString() + "." + baseMode;
                List<String> baseline = result.get(bmKey);
                if (baseline == null) {
                    throw new IllegalArgumentException("Cannot base runmode " + newMode + " on " + baseMode + ". Baseline not found in runmodes: " + baseline);
                }
                result.put(st.asString() + "." + newMode, baseline);
            }
            String newModeValues = runmodeProps.remove(newMode);
            if (newModeValues != null) {
                for (String pck : newModeValues.split(",")) {
                    for (ServiceType st : serviceTypes) {
                        result.get(st.asString() + "." + newMode).add(pck);
                    }
                }
            }
            for (ServiceType st : serviceTypes) {
                String rmp = st.asString() + "." + newMode;
                String newModeSpecific = runmodeProps.remove(rmp);
                if (newModeSpecific == null) continue;
                for (String pck : newModeSpecific.split(",")) {
                    result.get(rmp).add(pck);
                }
            }
        }
    }

    private static void reportUnhandledModes(HashMap<String, String> rmp) {
        for (String mode : rmp.keySet()) {
            String validMode = AemAnalyserUtil.getValidRunMode(mode);
            if (validMode != null) {
                throw new IllegalArgumentException("Invalid runmode " + mode + ". Please use this runmode instead: " + validMode);
            }
            LoggerFactory.getLogger((String)AemAnalyser.class.getName()).info("Ignoring unused runmode " + mode);
        }
    }

    private static List<String> sortPropertyNames(Set<String> stringPropertyNames) {
        ArrayList<String> names = new ArrayList<String>(stringPropertyNames);
        for (int i = 0; i < names.size(); ++i) {
            String n = (String)names.get(i);
            String n2 = n.replace("author", "AUTHOR");
            String n3 = n2.replace("publish", "PUBLISH");
            names.set(i, n3);
        }
        Collections.sort(names, (s1, s2) -> {
            int res = Long.compare(AemAnalyserUtil.countChars(s1), AemAnalyserUtil.countChars(s2));
            return res != 0 ? res : s1.compareTo((String)s2);
        });
        return names.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    private static long countChars(String s) {
        return s.chars().filter(c -> c == 46).count();
    }

    static void pruneModels(Map<String, List<String>> allModels, Set<String> additionalRunmodes) {
        Set allEnvs = Arrays.stream(EnvironmentType.values()).map(EnvironmentType::asString).collect(Collectors.toSet());
        allEnvs.addAll(additionalRunmodes);
        for (ServiceType ap : ServiceType.values()) {
            for (String env : allEnvs) {
                String mode = ap.asString().concat(".").concat(env);
                if (!Objects.equals(allModels.get(ap.asString()), allModels.get(mode))) continue;
                allModels.remove(mode);
            }
        }
    }
}

