/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.ProductFeatureGenerator;
import com.adobe.aem.analyser.ProductVariation;
import com.adobe.aem.analyser.SdkProductVariation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;

public class AemSdkProductFeatureGenerator
implements ProductFeatureGenerator {
    private final FeatureProvider featureProvider;
    private final ArtifactId sdkId;
    private final List<ArtifactId> addOnIds;

    public AemSdkProductFeatureGenerator(FeatureProvider featureProvider, ArtifactId sdkId, List<ArtifactId> addOnIds) {
        this.featureProvider = featureProvider;
        this.sdkId = sdkId;
        this.addOnIds = addOnIds == null ? Collections.emptyList() : addOnIds;
    }

    @Override
    public Map<ProductVariation, List<Feature>> getProductAggregates() throws IOException {
        HashMap<ProductVariation, List<Feature>> aggregates = new HashMap<ProductVariation, List<Feature>>();
        for (SdkProductVariation variation : SdkProductVariation.values()) {
            List list = aggregates.computeIfAbsent(variation, n -> new ArrayList());
            Feature sdkFeature = this.featureProvider.provide(this.sdkId.changeClassifier(variation.getSdkClassifier()).changeType("slingosgifeature"));
            if (sdkFeature == null) {
                throw new IOException("Unable to find SDK feature for " + this.sdkId.toMvnId());
            }
            list.add(sdkFeature);
            for (ArtifactId id : this.addOnIds) {
                Feature feature = this.featureProvider.provide(id.changeType("slingosgifeature"));
                if (feature == null) {
                    throw new IOException("Unable to find addon feature for " + id.toMvnId());
                }
                list.add(feature);
            }
        }
        return aggregates;
    }

    @Override
    public ProductVariation getVariation(String name) {
        if (name.startsWith("user-aggregated-author")) {
            return SdkProductVariation.AUTHOR;
        }
        return SdkProductVariation.PUBLISH;
    }
}

