/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactWriter;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.LocalMavenRepositoryArtifactsDeployer;
import org.apache.sling.feature.cpconverter.features.DefaultFeaturesManager;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.RegexBasedResourceFilter;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.DefaultEntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.vltpkg.DefaultPackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AemPackageConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FILTER = ".*/(apps|libs)/(.*)/install\\.(((author|publish)\\.(dev|stage|prod))|((dev|stage|prod)\\.(author|publish))|(dev|stage|prod))/(.*)(?<=\\.(zip|jar)$)";
    private File featureOutputDirectory;
    private File bundlesOutputDirectory;
    private File converterOutputDirectory;
    private String artifactIdOverride;

    public File getFeatureOutputDirectory() {
        return this.featureOutputDirectory;
    }

    public void setFeatureOutputDirectory(File featureOutputDirectory) {
        this.featureOutputDirectory = featureOutputDirectory;
    }

    public File getBundlesOutputDirectory() {
        return this.bundlesOutputDirectory;
    }

    public void setBundlesOutputDirectory(File bundlesOutputDirectory) {
        this.bundlesOutputDirectory = bundlesOutputDirectory;
    }

    public File getConverterOutputDirectory() {
        return this.converterOutputDirectory;
    }

    public void setConverterOutputDirectory(File converterOutputDirectory) {
        this.converterOutputDirectory = converterOutputDirectory;
    }

    public String getArtifactIdOverride() {
        return this.artifactIdOverride;
    }

    public void setArtifactIdOverride(String artifactIdOverride) {
        this.artifactIdOverride = artifactIdOverride;
    }

    public void convert(Map<String, File> contentPackages, List<String> additionalWarnings, List<String> additionalErrors) throws IOException, ConverterException {
        HashMap properties = new HashMap();
        DefaultAclManager aclManager = new DefaultAclManager(null, "system");
        DefaultFeaturesManager featuresManager = new DefaultFeaturesManager(false, 20, this.featureOutputDirectory, this.artifactIdOverride, null, properties, (AclManager)aclManager);
        featuresManager.setExportToAPIRegion("global");
        final HashMap mutableContentPackagesWithRunMode = new HashMap();
        File bundlesOutputDir = this.bundlesOutputDirectory != null ? this.bundlesOutputDirectory : this.converterOutputDirectory;
        try (ContentPackage2FeatureModelConverter converter = new ContentPackage2FeatureModelConverter(false, ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP);){
            converter.setFeaturesManager((FeaturesManager)featuresManager).setContentTypePackagePolicy(ContentPackage2FeatureModelConverter.PackagePolicy.PUT_IN_DEDICATED_FOLDER).setUnreferencedArtifactsDeployer(new ArtifactsDeployer(){

                @NotNull
                public String deploy(@NotNull ArtifactWriter artifactWriter, @Nullable String runmode, @NotNull ArtifactId id) throws IOException {
                    if (runmode != null) {
                        mutableContentPackagesWithRunMode.put(id, runmode);
                    }
                    return id.toMvnId();
                }
            }).setBundlesDeployer((ArtifactsDeployer)new LocalMavenRepositoryArtifactsDeployer(bundlesOutputDir)).setEntryHandlersManager((EntryHandlersManager)new DefaultEntryHandlersManager(Collections.emptyMap(), true, ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP, "system")).setEmitter((PackagesEventsEmitter)DefaultPackagesEventsEmitter.open((File)this.featureOutputDirectory)).setResourceFilter(this.getResourceFilter());
            this.logger.info("Converting packages {}", contentPackages.keySet());
            converter.convert(contentPackages.values().toArray(new File[contentPackages.size()]));
        }
        catch (IOException | ConverterException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Content Package Converter exception " + t.getMessage(), t);
        }
        if (!mutableContentPackagesWithRunMode.isEmpty()) {
            for (Map.Entry entry : mutableContentPackagesWithRunMode.entrySet()) {
                this.logger.info("Mutable content package {} uses runmode {}", (Object)((ArtifactId)entry.getKey()).toMvnId(), entry.getValue());
            }
        }
    }

    private ResourceFilter getResourceFilter() {
        RegexBasedResourceFilter filter = new RegexBasedResourceFilter();
        filter.addFilteringPattern(FILTER);
        return filter;
    }
}

