/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import acscommons.com.google.common.collect.ImmutableMap;
import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class}, property={"process.label=Synchronize Smart Tags to XMP Metadata Node"})
public class SyncSmartTagsToXmpMetadataNodeProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SyncSmartTagsToXmpMetadataNodeProcess.class);
    private static final String NN_PREDICTED_TAGS = "predictedTags";
    private static final String PN_SMART_TAG_NAME = "name";
    private static final String PN_SMART_TAG_CONFIDENCE = "confidence";
    private static final String DEFAULT_NN_SEQUENCE = "dam:predictedTags";
    private static final String DEFAULT_PN_PREDICATED_TAGS_NAME = "dam:predictedTagName";
    private static final String DEFAULT_PN_PREDICATED_TAGS_CONFIDENCE = "dam:predictedTagConfidence";
    private static final Double DEFAULT_MINIMUM_CONFIDENCE = 0.0;
    @Reference
    private WorkflowHelper workflowHelper;
    @Reference
    private WorkflowPackageManager workflowPackageManager;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        log.debug("Invoked syncSmartTagsToMetadata Workflow Process step for payload [ {} ]", workItem.getWorkflowData().getPayload());
        ProcessArgs processArgs = new ProcessArgs(metaDataMap);
        try (ResourceResolver resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);){
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, (String)workItem.getWorkflowData().getPayload());
            List assets = payloads.stream().map(payload -> DamUtil.resolveToAsset((Resource)resourceResolver.getResource(payload))).filter(Objects::nonNull).collect(Collectors.toList());
            assets.stream().forEach(asset -> {
                try {
                    this.syncSmartTagsToMetadata((Asset)asset, processArgs);
                }
                catch (PersistenceException e) {
                    log.error("Unable to sync Smart Tags to XMP Metadata structure for asset [ {} ]", (Object)asset.getPath(), (Object)e);
                }
            });
        }
        catch (RepositoryException e) {
            log.error("Could not find the payload", (Throwable)e);
            throw new WorkflowException("Could not find the payload");
        }
    }

    protected void syncSmartTagsToMetadata(Asset asset, ProcessArgs processArgs) throws PersistenceException {
        Resource assetResource = (Resource)asset.adaptTo(Resource.class);
        ResourceResolver resourceResolver = assetResource.getResourceResolver();
        Resource metadataResource = assetResource.getChild("jcr:content/metadata");
        Resource smartTagsResource = assetResource.getChild("jcr:content/metadata/predictedTags");
        if (metadataResource.getChild(processArgs.getSequenceName()) != null) {
            resourceResolver.delete(metadataResource.getChild(processArgs.getSequenceName()));
        }
        Resource parentResource = resourceResolver.create(metadataResource, processArgs.getSequenceName(), new ImmutableMap.Builder<String, String>().put("jcr:primaryType", "nt:unstructured").put("xmpArrayType", "rdf:Seq").put("xmpNodeType", "xmpArray").put("xmpArraySize", (String)((Object)Long.valueOf(0L))).build());
        AtomicInteger count = new AtomicInteger(0);
        if (smartTagsResource != null) {
            StreamSupport.stream(smartTagsResource.getChildren().spliterator(), false).map(Resource::getValueMap).filter(properties -> (Double)properties.get(PN_SMART_TAG_CONFIDENCE, (Object)0.0) >= processArgs.getMinimumConfidence()).filter(properties -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)properties.get(PN_SMART_TAG_NAME, String.class)))).forEach(properties -> this.createSequenceItemResource(asset, processArgs, resourceResolver, parentResource, count, (ValueMap)properties));
        }
        ((ModifiableValueMap)parentResource.adaptTo(ModifiableValueMap.class)).put((Object)"xmpArraySize", (Object)count.get());
        log.info("Synced [ {} ] Smart Tags to Asset XMP Metadata structure: [ {} ] ", (Object)count.get(), (Object)(asset.getPath() + "/jcr:content/metadata/" + processArgs.getSequenceName()));
    }

    private void createSequenceItemResource(Asset asset, ProcessArgs processArgs, ResourceResolver resourceResolver, Resource parentResource, AtomicInteger count, ValueMap properties) {
        try {
            resourceResolver.create(parentResource, String.valueOf(count.incrementAndGet()), new ImmutableMap.Builder<String, String>().put("jcr:primaryType", "nt:unstructured").put("xmpNodeType", "xmpStruct").put(processArgs.getNameProperty(), (String)properties.get(PN_SMART_TAG_NAME, String.class)).put(processArgs.getConfidenceProperty(), (String)properties.get(PN_SMART_TAG_CONFIDENCE, Double.class)).build());
        }
        catch (PersistenceException e) {
            log.error("Unable to sync Smart Tag [ {} ] to XMP Metadata structure for asset [ {} ]", new Object[]{properties.get(PN_SMART_TAG_NAME, String.class), asset.getPath(), e});
        }
    }

    protected static class ProcessArgs {
        private static final String ARG_SEQUENCE_NAME = "sequenceName";
        private static final String ARG_NAME_PROPERTY = "nameProperty";
        private static final String ARG_CONFIDENCE_PROPERTY = "confidenceProperty";
        private static final String ARG_MINIMUM_CONFIDENCE = "minimumConfidence";
        private String sequenceName;
        private String nameProperty;
        private String confidenceProperty;
        private Double minimumConfidence;

        public ProcessArgs(MetaDataMap map) {
            String[] lines = StringUtils.split((String)((String)map.get("PROCESS_ARGS", (Object)"")), (String)System.lineSeparator());
            Map<String, String> data = ParameterUtil.toMap(lines, "=");
            this.sequenceName = (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)data.get(ARG_SEQUENCE_NAME), (CharSequence)SyncSmartTagsToXmpMetadataNodeProcess.DEFAULT_NN_SEQUENCE);
            this.nameProperty = (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)data.get(ARG_NAME_PROPERTY), (CharSequence)SyncSmartTagsToXmpMetadataNodeProcess.DEFAULT_PN_PREDICATED_TAGS_NAME);
            this.confidenceProperty = (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)data.get(ARG_CONFIDENCE_PROPERTY), (CharSequence)SyncSmartTagsToXmpMetadataNodeProcess.DEFAULT_PN_PREDICATED_TAGS_CONFIDENCE);
            try {
                String tmp = data.get(ARG_MINIMUM_CONFIDENCE);
                this.minimumConfidence = tmp == null ? DEFAULT_MINIMUM_CONFIDENCE : Double.valueOf(Double.parseDouble(tmp));
            }
            catch (NullPointerException | NumberFormatException e) {
                log.warn("Could not parse Double from [ {} ] defaulting to [ {} ]", (Object)data.get(ARG_MINIMUM_CONFIDENCE), (Object)DEFAULT_MINIMUM_CONFIDENCE);
                this.minimumConfidence = DEFAULT_MINIMUM_CONFIDENCE;
            }
            if (this.minimumConfidence < 0.0 || this.minimumConfidence > 1.0) {
                log.warn("Minimum confidence score [ {} ] outside of range [ 0 to 1 ] defaulting to [ {} ]", (Object)data.get(ARG_MINIMUM_CONFIDENCE), (Object)DEFAULT_MINIMUM_CONFIDENCE);
                this.minimumConfidence = DEFAULT_MINIMUM_CONFIDENCE;
            }
        }

        public double getMinimumConfidence() {
            return this.minimumConfidence;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public String getNameProperty() {
            return this.nameProperty;
        }

        public String getConfidenceProperty() {
            return this.confidenceProperty;
        }
    }
}

