/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.model;

import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class PayloadGroup {
    public static final String PN_NEXT = "next";
    private final Resource resource;
    @Inject
    @Optional
    private String next;

    public PayloadGroup(Resource resource) {
        this.resource = resource;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getDereferencedPath() {
        return PayloadGroup.dereference(this.resource.getPath());
    }

    public Workspace getWorkspace() {
        return (Workspace)this.resource.getParent().adaptTo(Workspace.class);
    }

    public PayloadGroup getNextPayloadGroup() {
        if (this.next == null) {
            return null;
        }
        Resource r = this.resource.getResourceResolver().getResource(this.getNext());
        if (r == null) {
            return null;
        }
        return (PayloadGroup)r.adaptTo(PayloadGroup.class);
    }

    public String getNext() {
        return PayloadGroup.reference(this.next);
    }

    public List<Payload> getPayloads() {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (Resource r : this.resource.getChildren()) {
            Payload payload = (Payload)r.adaptTo(Payload.class);
            if (payload == null) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    public Payload getNextPayload() {
        for (Resource r : this.resource.getChildren()) {
            Payload payload = (Payload)r.adaptTo(Payload.class);
            if (payload == null || payload.isOnboarded()) continue;
            return payload;
        }
        return null;
    }

    public boolean isLast() {
        return this.getNextPayloadGroup() == null;
    }

    public static String dereference(String str) {
        if (!StringUtils.startsWith((String)str, (String)"-")) {
            str = "-" + str;
        }
        return str;
    }

    public static String reference(String str) {
        return StringUtils.removeStart((String)str, (String)"-");
    }
}

