/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.remoteassets.impl;

import com.adobe.acs.commons.remoteassets.RemoteAssetsNodeSync;
import com.adobe.acs.commons.remoteassets.impl.RemoteAssetsConfigImpl;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={RemoteAssetsNodeSync.class})
public class RemoteAssetsNodeSyncImpl
implements RemoteAssetsNodeSync {
    private static final String REP_POLICY = "rep:policy";
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAssetsNodeSyncImpl.class);
    private static final Pattern DATE_REGEX = Pattern.compile("[A-Za-z]{3}\\s[A-Za-z]{3}\\s\\d\\d\\s\\d\\d\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\sGMT[-+]\\d\\d\\d\\d");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", Locale.US);
    private static final Pattern DECIMAL_REGEX = Pattern.compile("-?\\d+\\.\\d+");
    private static final String ASSET_FILE_PREFIX = "remoteassets/remote_asset";
    private static final Set<String> PROTECTED_PROPERTIES = new HashSet<String>(Arrays.asList("jcr:created", "jcr:createdBy", "jcr:versionHistory", "jcr:baseVersion", "jcr:isCheckedOut", "jcr:uuid", "jcr:predecessors"));
    private static final Set<String> PROTECTED_NODES = new HashSet<String>(Arrays.asList("folderThumbnail", "rep:policy"));
    @Reference
    private RemoteAssetsConfigImpl remoteAssetsConfig;
    private int saveRefreshCount = 0;

    @Override
    public void syncAssetNodes() {
        try (ResourceResolver remoteAssetsResolver = this.remoteAssetsConfig.getResourceResolver();){
            ArrayList<String> syncPaths = new ArrayList<String>();
            syncPaths.addAll(this.remoteAssetsConfig.getTagSyncPaths());
            syncPaths.addAll(this.remoteAssetsConfig.getDamSyncPaths());
            for (String syncPath : syncPaths) {
                LOG.info("Starting sync of nodes for {}", (Object)syncPath);
                remoteAssetsResolver.refresh();
                JsonObject topLevelJsonWithChildren = this.getJsonFromUri(syncPath);
                String resourcePrimaryType = topLevelJsonWithChildren.getAsJsonPrimitive("jcr:primaryType").getAsString();
                Resource topLevelSyncResource = this.getOrCreateNode(remoteAssetsResolver, syncPath, resourcePrimaryType);
                this.createOrUpdateNodes(remoteAssetsResolver, topLevelJsonWithChildren, topLevelSyncResource);
                remoteAssetsResolver.commit();
                LOG.info("Completed sync of nodes for {}", (Object)syncPath);
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected error sync'ing remote asset nodes", (Throwable)e);
        }
    }

    private Resource getOrCreateNode(ResourceResolver remoteAssetsResolver, String nextPath, String primaryType) throws RepositoryException {
        Resource resource;
        try {
            resource = remoteAssetsResolver.getResource(nextPath);
            if (resource == null) {
                Node node = JcrUtil.createPath((String)nextPath, (String)primaryType, (Session)((Session)remoteAssetsResolver.adaptTo(Session.class)));
                resource = remoteAssetsResolver.getResource(node.getPath());
                LOG.debug("New resource '{}' created.", (Object)resource.getPath());
            } else {
                LOG.debug("Resource '{}' retrieved from JCR.", (Object)resource.getPath());
            }
        }
        catch (RepositoryException re) {
            LOG.error("Repository Exception. Unable to get or create resource '{}'", (Object)nextPath, (Object)re);
            throw re;
        }
        return resource;
    }

    private JsonObject getJsonFromUri(String path) throws IOException {
        URI pathUri;
        try {
            pathUri = new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            LOG.error("URI Syntax Exception", (Throwable)e);
            throw new IOException("Invalid URI", e);
        }
        String url = this.remoteAssetsConfig.getServer() + pathUri.toString() + ".1.json";
        Executor executor = this.remoteAssetsConfig.getRemoteAssetsHttpExecutor();
        String responseString = executor.execute(Request.Get((String)url)).returnContent().asString();
        try {
            JsonObject responseJson = new JsonParser().parse(responseString).getAsJsonObject();
            LOG.debug("JSON successfully fetched for URL '{}'.", (Object)url);
            return responseJson;
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            LOG.error("Unable to grab JSON Object. Please ensure URL {} is valid. \nRaw Response: {}", (Object)url, (Object)responseString);
            throw new IOException("Invalid JSON response", e);
        }
    }

    private void createOrUpdateNodes(ResourceResolver remoteAssetsResolver, JsonObject json, Resource resource) throws IOException, RepositoryException {
        for (Map.Entry jsonEntry : json.entrySet()) {
            JsonElement jsonElement = (JsonElement)jsonEntry.getValue();
            if (jsonElement.isJsonObject()) {
                this.createOrUpdateNodesForJsonObject(remoteAssetsResolver, (String)jsonEntry.getKey(), resource);
                continue;
            }
            if (jsonElement.isJsonArray()) {
                this.setNodeArrayProperty(remoteAssetsResolver, (String)jsonEntry.getKey(), jsonElement.getAsJsonArray(), resource);
                continue;
            }
            this.setNodeProperty(remoteAssetsResolver, (String)jsonEntry.getKey(), json, resource);
        }
    }

    private void createOrUpdateNodesForJsonObject(ResourceResolver remoteAssetsResolver, String key, Resource parentResource) throws IOException, RepositoryException {
        if (PROTECTED_NODES.contains(key)) {
            return;
        }
        String objectPath = String.format("%s/%s", parentResource.getPath(), key);
        JsonObject jsonObjectWithChildren = this.getJsonFromUri(objectPath);
        String resourcePrimaryType = jsonObjectWithChildren.getAsJsonPrimitive("jcr:primaryType").getAsString();
        Resource resource = this.getOrCreateNode(remoteAssetsResolver, objectPath, resourcePrimaryType);
        this.createOrUpdateNodes(remoteAssetsResolver, jsonObjectWithChildren, resource);
        ValueMap resourceProperties = (ValueMap)resource.adaptTo(ModifiableValueMap.class);
        if ("dam:Asset".equals(parentResource.getValueMap().get("jcr:primaryType", String.class)) && "dam:AssetContent".equals(resourceProperties.get("jcr:primaryType", String.class))) {
            resourceProperties.put((Object)"isRemoteAsset", (Object)true);
            LOG.trace("Property '{}' added for resource '{}'.", (Object)"isRemoteAsset", (Object)resource.getPath());
            ++this.saveRefreshCount;
            if (this.saveRefreshCount == this.remoteAssetsConfig.getSaveInterval()) {
                this.saveRefreshCount = 0;
                remoteAssetsResolver.commit();
                remoteAssetsResolver.refresh();
                LOG.info("Executed incremental save of node sync.");
            }
        }
    }

    private void setNodeProperty(ResourceResolver remoteAssetsResolver, String key, JsonObject json, Resource resource) throws RepositoryException {
        try {
            JsonElement value = json.get(key);
            if (":".concat("jcr:data").equals(key)) {
                this.setNodeJcrDataProperty(remoteAssetsResolver, resource, json.getAsJsonPrimitive("jcr:lastModified").getAsString());
            } else {
                if (key.startsWith(":")) {
                    return;
                }
                if (PROTECTED_PROPERTIES.contains(key)) {
                    return;
                }
                if (resource.getValueMap().get((Object)key) != null && ((String)resource.getValueMap().get(key, String.class)).equals(value.getAsString())) {
                    return;
                }
                this.setNodeSimpleProperty(value.getAsJsonPrimitive(), key, resource);
            }
        }
        catch (RepositoryException re) {
            LOG.warn("Repository exception thrown. Skipping '{}' single property for resource '{}'.", (Object)key, (Object)resource.getPath());
        }
    }

    private void setNodeArrayProperty(ResourceResolver remoteAssetsResolver, String key, JsonArray jsonArray, Resource resource) throws RepositoryException {
        try {
            if (PROTECTED_PROPERTIES.contains(key)) {
                return;
            }
            if ("jcr:mixinTypes".equals(key)) {
                this.setNodeMixinsProperty(jsonArray, key, resource);
            } else if ("cq:tags".equals(key)) {
                this.setNodeTagsProperty(remoteAssetsResolver, jsonArray, resource);
            } else {
                this.setNodeSimpleArrayProperty(jsonArray, key, resource);
            }
        }
        catch (RepositoryException re) {
            LOG.warn("Repository exception thrown. Skipping {} array property for resource '{}'.", (Object)key, (Object)resource.getPath());
        }
    }

    protected void setNodeMixinsProperty(JsonArray jsonArray, String key, Resource resource) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        for (JsonElement jsonElement : jsonArray) {
            LOG.trace("Adding mixin '{}' for resource '{}'.", (Object)jsonElement.getAsString(), (Object)resource.getPath());
            node.addMixin(jsonElement.getAsString());
        }
    }

    private void setNodeTagsProperty(ResourceResolver remoteAssetsResolver, JsonArray jsonArray, Resource resource) throws RepositoryException {
        TagManager tagManager = (TagManager)remoteAssetsResolver.adaptTo(TagManager.class);
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (JsonElement jsonElement : jsonArray) {
            Tag tag = tagManager.resolve(jsonElement.getAsString());
            if (tag == null) {
                LOG.warn("Tag '{}' could not be found. Skipping tag for resource '{}'.", (Object)jsonElement.getAsString(), (Object)resource.getPath());
                continue;
            }
            tagList.add(tag);
        }
        if (tagList.size() > 0) {
            tagManager.setTags(resource, tagList.toArray(new Tag[tagList.size()]));
            LOG.trace("Tags added for resource '{}'.", (Object)resource.getPath());
        }
    }

    private void setNodeSimpleArrayProperty(JsonArray jsonArray, String key, Resource resource) throws RepositoryException {
        JsonPrimitive firstVal = jsonArray.get(0).getAsJsonPrimitive();
        try {
            int i;
            Object[] values;
            if (firstVal.isBoolean()) {
                values = new Boolean[jsonArray.size()];
                for (i = 0; i < jsonArray.size(); ++i) {
                    values[i] = jsonArray.get(i).getAsBoolean();
                }
            } else if (DECIMAL_REGEX.matcher(firstVal.getAsString()).matches()) {
                values = new BigDecimal[jsonArray.size()];
                for (i = 0; i < jsonArray.size(); ++i) {
                    values[i] = jsonArray.get(i).getAsBigDecimal();
                }
            } else if (firstVal.isNumber()) {
                values = new Long[jsonArray.size()];
                for (i = 0; i < jsonArray.size(); ++i) {
                    values[i] = jsonArray.get(i).getAsLong();
                }
            } else {
                values = new String[jsonArray.size()];
                for (i = 0; i < jsonArray.size(); ++i) {
                    values[i] = jsonArray.get(i).getAsString();
                }
            }
            ValueMap resourceProperties = (ValueMap)resource.adaptTo(ModifiableValueMap.class);
            resourceProperties.put((Object)key, (Object)values);
            LOG.trace("Array property '{}' added for resource '{}'", (Object)key, (Object)resource.getPath());
        }
        catch (Exception e) {
            LOG.error("Unable to assign property '{}' to resource '{}'", new Object[]{key, resource.getPath(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodeJcrDataProperty(ResourceResolver remoteAssetsResolver, Resource resource, String rawResponseLastModified) throws RepositoryException {
        ValueMap resourceProperties = (ValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (resourceProperties.get((Object)"jcr:lastModified") != null && resourceProperties.get((Object)"jcr:data") != null && StringUtils.isNotEmpty((CharSequence)rawResponseLastModified)) {
            String resourceLastModified = (String)resourceProperties.get("jcr:lastModified", String.class);
            GregorianCalendar remoteLastModified = GregorianCalendar.from(ZonedDateTime.parse(rawResponseLastModified, DATE_TIME_FORMATTER));
            ValueFactory valueFactory = ((Session)remoteAssetsResolver.adaptTo(Session.class)).getValueFactory();
            if (resourceLastModified.equals(valueFactory.createValue((Calendar)remoteLastModified).getString())) {
                LOG.debug("Not creating binary for resource '{}' because binary has not been updated.", (Object)resource.getPath());
                return;
            }
        }
        InputStream inputStream = this.getRemoteAssetPlaceholder(resource);
        try {
            resourceProperties.put((Object)"jcr:data", (Object)inputStream);
            LOG.debug("Binary added for resource '{}'.", (Object)resource.getPath());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ie) {
                LOG.error("IOException thrown {}", (Throwable)ie);
            }
        }
    }

    private void setNodeSimpleProperty(JsonPrimitive value, String key, Resource resource) throws RepositoryException {
        ValueMap resourceProperties = (ValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (value.isString() && DATE_REGEX.matcher(value.getAsString()).matches()) {
            try {
                resourceProperties.put((Object)key, (Object)GregorianCalendar.from(ZonedDateTime.parse(value.getAsString(), DATE_TIME_FORMATTER)));
            }
            catch (DateTimeParseException e) {
                LOG.warn("Unable to parse date '{}' for property:resource '{}'.", (Object)value, (Object)(key + ":" + resource.getPath()));
            }
        } else if (value.isString() && DECIMAL_REGEX.matcher(value.getAsString()).matches()) {
            resourceProperties.put((Object)key, (Object)value.getAsBigDecimal());
        } else if (value.isBoolean()) {
            resourceProperties.put((Object)key, (Object)value.getAsBoolean());
        } else if (value.isNumber()) {
            if (DECIMAL_REGEX.matcher(value.getAsString()).matches()) {
                resourceProperties.put((Object)key, (Object)value.getAsBigDecimal());
            } else {
                resourceProperties.put((Object)key, (Object)value.getAsLong());
            }
        } else if (value.isJsonNull()) {
            resourceProperties.remove((Object)key);
        } else {
            resourceProperties.put((Object)key, (Object)value.getAsString());
        }
        LOG.trace("Property '{}' added for resource '{}'.", (Object)key, (Object)resource.getPath());
    }

    protected InputStream getRemoteAssetPlaceholder(Resource renditionContentResource) throws RepositoryException {
        InputStream inputStream;
        String mimeType;
        switch (mimeType = (String)renditionContentResource.getValueMap().get((Object)"jcr:mimeType")) {
            case "video/3gpp2": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.3g2");
                break;
            }
            case "video/3gpp": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.3gp");
                break;
            }
            case "audio/x-aac": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.aac");
                break;
            }
            case "audio/x-aiff": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.aiff");
                break;
            }
            case "video/x-msvideo": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.avi");
                break;
            }
            case "image/bmp": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.bmp");
                break;
            }
            case "text/css": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.css");
                break;
            }
            case "application/msword": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.doc");
                break;
            }
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.docx");
                break;
            }
            case "application/postscript": {
                inputStream = this.getCorrectBinaryTypeStream(renditionContentResource, "ai", "eps", "ps");
                break;
            }
            case "application/epub+zip": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.epub");
                break;
            }
            case "video/x-f4v": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.f4v");
                break;
            }
            case "application/x-shockwave-flash": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.swf");
                break;
            }
            case "image/gif": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.gif");
                break;
            }
            case "text/html": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.html");
                break;
            }
            case "application/x-indesign": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.indd");
                break;
            }
            case "application/java-archive": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.jar");
                break;
            }
            case "image/jpeg": {
                inputStream = this.getCorrectBinaryTypeStream(renditionContentResource, "jpeg", "jpg");
                break;
            }
            case "video/x-m4v": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.m4v");
                break;
            }
            case "audio/midi": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.midi");
                break;
            }
            case "video/quicktime": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.mov");
                break;
            }
            case "audio/mpeg": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.mp3");
                break;
            }
            case "video/mp4": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.mp4");
                break;
            }
            case "video/mpeg": {
                inputStream = this.getCorrectBinaryTypeStream(renditionContentResource, "m2v", "mpeg", "mpg");
                break;
            }
            case "audio/ogg": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.ogg");
                break;
            }
            case "video/ogg": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.ogv");
                break;
            }
            case "application/pdf": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.pdf");
                break;
            }
            case "image/png": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.png");
                break;
            }
            case "application/vnd.ms-powerpoint": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.ppt");
                break;
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.pptx");
                break;
            }
            case "image/vnd.adobe.photoshop": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.psd");
                break;
            }
            case "application/x-rar-compressed": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.rar");
                break;
            }
            case "application/rtf": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.rtf");
                break;
            }
            case "image/svg+xml": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.svg");
                break;
            }
            case "application/x-tar": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.tar");
                break;
            }
            case "image/tiff": {
                inputStream = this.getCorrectBinaryTypeStream(renditionContentResource, "tif", "tiff");
                break;
            }
            case "text/plain": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.txt");
                break;
            }
            case "audio/x-wav": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.wav");
                break;
            }
            case "video/webm": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.webm");
                break;
            }
            case "audio/x-ms-wma": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.wma");
                break;
            }
            case "video/x-ms-wmv": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.wmv");
                break;
            }
            case "application/vnd.ms-excel": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.xls");
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.xlsx");
                break;
            }
            case "application/xml": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.xml");
                break;
            }
            case "application/zip": {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.zip");
                break;
            }
            default: {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("remoteassets/remote_asset.jpeg");
            }
        }
        return inputStream;
    }

    private InputStream getCorrectBinaryTypeStream(Resource renditionContentResource, String ... fileExtensions) throws RepositoryException {
        Resource renditionResource = renditionContentResource.getParent();
        Asset assetResource = DamUtil.resolveToAsset((Resource)renditionResource);
        String remoteAssetFileUri = "remoteassets/remote_asset." + fileExtensions[0];
        String assetFileExtension = FilenameUtils.getExtension((String)assetResource.getName());
        String renditionParentFileExtension = FilenameUtils.getExtension((String)renditionResource.getName());
        for (String fileExtension : fileExtensions) {
            if ((!"original".equals(renditionResource.getName()) || !fileExtension.equals(assetFileExtension)) && ("original".equals(renditionResource.getName()) || !fileExtension.equals(renditionParentFileExtension))) continue;
            remoteAssetFileUri = "remoteassets/remote_asset." + fileExtension;
            break;
        }
        return this.getClass().getClassLoader().getResourceAsStream(remoteAssetFileUri);
    }
}

