/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.remoteassets.impl;

import com.adobe.acs.commons.remoteassets.RemoteAssetsBinarySync;
import com.adobe.acs.commons.remoteassets.impl.RemoteAssetsConfigImpl;
import java.util.Calendar;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceDecorator.class})
public class RemoteAssetDecorator
implements ResourceDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAssetDecorator.class);
    private static int SYNC_WAIT_SECONDS = 100;
    private static String ADMIN_ID = "admin";
    private static Set<String> remoteResourcesSyncing = new ConcurrentSkipListSet<String>();
    @Reference
    private RemoteAssetsBinarySync assetSync;
    @Reference
    private RemoteAssetsConfigImpl config;

    public Resource decorate(Resource resource) {
        try {
            if (!this.accepts(resource)) {
                return resource;
            }
        }
        catch (Exception e) {
            LOG.debug("Failed binary sync check for remote asset: {}", (Object)resource.getPath());
            return resource;
        }
        boolean syncSuccessful = false;
        syncSuccessful = this.isAlreadySyncing(resource.getPath()) ? this.waitForSyncInProgress(resource) : this.syncAssetBinaries(resource);
        if (syncSuccessful) {
            LOG.trace("Refreshing resource after binary sync of {}", (Object)resource.getPath());
            resource.getResourceResolver().refresh();
            return resource.getResourceResolver().getResource(resource.getPath());
        }
        return resource;
    }

    @Deprecated
    public Resource decorate(Resource resource, HttpServletRequest request) {
        return this.decorate(resource);
    }

    protected boolean accepts(Resource resource) throws RepositoryException {
        ValueMap props = resource.getValueMap();
        if (!"dam:AssetContent".equals(props.get((Object)"jcr:primaryType"))) {
            return false;
        }
        if (!((Boolean)props.get("isRemoteAsset", (Object)false)).booleanValue()) {
            return false;
        }
        Calendar lastFailure = (Calendar)props.get("remoteSyncFailed", (Object)null);
        if (lastFailure != null && System.currentTimeMillis() < lastFailure.getTimeInMillis() + (long)(this.config.getRetryDelay() * 60000)) {
            return false;
        }
        boolean matchesSyncPath = false;
        for (String syncPath : this.config.getDamSyncPaths()) {
            if (!resource.getPath().startsWith(syncPath)) continue;
            matchesSyncPath = true;
        }
        return matchesSyncPath && this.isAllowedUser(resource);
    }

    private boolean isAllowedUser(Resource resource) throws RepositoryException {
        ResourceResolver resourceResolver = resource.getResourceResolver();
        String userId = resourceResolver.getUserID();
        if (!userId.equals(ADMIN_ID)) {
            if (this.config.getWhitelistedServiceUsers().contains(userId)) {
                return true;
            }
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            User currentUser = (User)this.getUserManager(session).getAuthorizable(userId);
            if (currentUser != null && !currentUser.isSystemUser()) {
                return true;
            }
            LOG.trace("Avoiding binary sync b/c this is a non-whitelisted service user: {}", (Object)session.getUserID());
        } else {
            LOG.trace("Avoiding binary sync for admin user");
        }
        return false;
    }

    protected boolean isAlreadySyncing(String resourcePath) {
        return remoteResourcesSyncing.contains(resourcePath);
    }

    private boolean waitForSyncInProgress(Resource resource) {
        String resourcePath = resource.getPath();
        LOG.debug("Already sync'ing {} - waiting for parallel sync to complete", (Object)resourcePath);
        try {
            long originalTime = System.currentTimeMillis();
            while (this.isAlreadySyncing(resourcePath) && System.currentTimeMillis() - originalTime < (long)(1000 * SYNC_WAIT_SECONDS)) {
                Thread.sleep(100L);
            }
            if (!this.isAlreadySyncing(resourcePath)) {
                LOG.debug("Parallel sync of {} complete", (Object)resourcePath);
                return true;
            }
            LOG.warn("Waited {} seconds for parallel binary sync to complete for: {} - giving up", (Object)SYNC_WAIT_SECONDS, (Object)resourcePath);
        }
        catch (Exception e) {
            LOG.error("Failed to wait for parallel binary sync for remote asset: {}", (Object)resourcePath, (Object)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncAssetBinaries(Resource resource) {
        String resourcePath = resource.getPath();
        try {
            remoteResourcesSyncing.add(resourcePath);
            LOG.info("Sync'ing remote asset binaries: {}", (Object)resourcePath);
            if (this.assetSync.syncAsset(resource)) {
                LOG.debug("Sync of remote asset binaries for {} complete", (Object)resourcePath);
                boolean bl = true;
                return bl;
            }
            LOG.error("Failed to sync binaries for remote asset: {}", (Object)resourcePath);
        }
        catch (Exception e) {
            LOG.error("Failed to sync binaries for remote asset: {}", (Object)resourcePath, (Object)e);
        }
        finally {
            remoteResourcesSyncing.remove(resourcePath);
        }
        return false;
    }

    protected UserManager getUserManager(Session session) throws RepositoryException {
        return AccessControlUtil.getUserManager((Session)session);
    }
}

