/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubstitutionElement {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public abstract String evaluate(Matcher var1);

    public static SubstitutionElement[] parse(String targetPath) {
        ArrayList<SubstitutionElement> elements = new ArrayList<SubstitutionElement>();
        int pos = 0;
        while (pos < targetPath.length()) {
            String value;
            int dollarPos = targetPath.indexOf(36, pos);
            if (dollarPos == -1) {
                value = targetPath.substring(pos);
                pos = targetPath.length();
                elements.add(new StaticElement(value));
                continue;
            }
            if (dollarPos + 1 == targetPath.length()) {
                value = targetPath.substring(pos, dollarPos + 1);
                elements.add(new StaticElement(value));
                log.warn("invalid back reference at pos({}): {}", (Object)dollarPos, (Object)targetPath);
                break;
            }
            if (pos < dollarPos) {
                value = targetPath.substring(pos, dollarPos);
                pos = dollarPos;
                elements.add(new StaticElement(value));
            }
            if (Character.isDigit(targetPath.charAt(dollarPos + 1))) {
                int group = Character.digit(targetPath.charAt(dollarPos + 1), 10);
                pos = dollarPos + 2;
                elements.add(new BackReferenceElement(group));
                continue;
            }
            value = targetPath.substring(pos, dollarPos + 2);
            pos = dollarPos + 2;
            elements.add(new StaticElement(value));
            log.warn("invalid back reference at pos({}): {}", (Object)dollarPos, (Object)targetPath);
        }
        return elements.toArray(new SubstitutionElement[0]);
    }

    public static class StaticElement
    extends SubstitutionElement {
        private final String value;

        StaticElement(String str) {
            this.value = str;
        }

        @Override
        public String evaluate(Matcher rule) {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class BackReferenceElement
    extends SubstitutionElement {
        private int n;

        BackReferenceElement(int group) {
            this.n = group;
        }

        @Override
        public String evaluate(Matcher rule) {
            String result = this.n <= rule.groupCount() ? rule.group(this.n) : null;
            return result == null ? "" : result;
        }

        public String toString() {
            return "$" + this.n;
        }
    }
}

