/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.impl;

import com.adobe.acs.commons.redirectmaps.impl.RedirectEntriesUtils;
import com.adobe.acs.commons.util.RequireAem;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/redirectmappage"}, selectors={"addentry"}, extensions={"json"}, metatype=false)
public class AddEntryServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1704915461516132101L;
    private static final Logger log = LoggerFactory.getLogger(AddEntryServlet.class);
    @Reference(target="(distribution=classic)")
    transient RequireAem requireAem;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        log.trace("doPost");
        String source = request.getParameter("source");
        String target = request.getParameter("target");
        log.debug("Adding entry with {} {}", (Object)source, (Object)target);
        List<String> lines = RedirectEntriesUtils.readEntries(request);
        lines.add(source + " " + target);
        log.debug("Added entry...");
        RedirectEntriesUtils.updateRedirectMap(request, lines);
        RedirectEntriesUtils.writeEntriesToResponse(request, response, "Added entry " + source + " " + target);
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }
}

