/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.ParentResourceValueMapValue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=2147483647"}, service={Injector.class})
public class ParentResourceValueMapValueInjector
implements Injector {
    public String getName() {
        return "parent-valuemap-value";
    }

    public Object getValue(Object adaptable, String name, Type type, AnnotatedElement annotatedElement, DisposalCallbackRegistry disposalCallbackRegistry) {
        if (!annotatedElement.isAnnotationPresent(ParentResourceValueMapValue.class)) {
            return null;
        }
        Integer maxLevel = annotatedElement.getAnnotation(ParentResourceValueMapValue.class).maxLevel();
        if (adaptable instanceof Resource) {
            return this.getInheritedProperty((Resource)adaptable, name, type, maxLevel);
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            Resource adaptableResource = ((SlingHttpServletRequest)adaptable).getResource();
            return this.getInheritedProperty(adaptableResource, name, type, maxLevel);
        }
        return null;
    }

    private Object getInheritedProperty(Resource resource, String propertyName, Type declaredType, Integer maxLevel) {
        int count = 0;
        for (Resource parentResource = resource.getParent(); parentResource != null && !parentResource.getResourceType().equals("cq:Page"); parentResource = parentResource.getParent()) {
            Object value = parentResource.getValueMap().get(propertyName, (Class)declaredType);
            if (!ObjectUtils.anyNotNull((Object[])new Object[]{value})) continue;
            return value;
        }
        return null;
    }
}

