/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.fam.Failure;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class ArchivedProcessFailure {
    @Inject
    public Date time;
    @Inject
    public String error;
    @Inject
    public String nodePath;
    @Inject
    public String stackTrace;

    public static ArchivedProcessFailure adapt(Failure source) {
        ArchivedProcessFailure dest = new ArchivedProcessFailure();
        if (source.getException() != null) {
            dest.time = source.getTime().getTime();
            dest.error = source.getException().getMessage();
            dest.stackTrace = ExceptionUtils.getStackTrace((Throwable)source.getException());
        }
        dest.nodePath = source.getNodePath();
        return dest;
    }
}

