/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.mcp.McpLocalizationService;
import com.adobe.acs.commons.mcp.impl.McpLocalizationConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={McpLocalizationService.class})
@Designate(ocd=McpLocalizationConfiguration.class)
public class McpLocalizationServiceImpl
implements McpLocalizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpLocalizationServiceImpl.class);
    private boolean localizationEnabled;
    private String overlayedLanguagesResourcePath;

    @Activate
    protected void activate(McpLocalizationConfiguration config) throws Exception {
        LOGGER.debug("Start ACTIVATE GenericListService");
        this.localizationEnabled = config.localizationEnabled();
        this.validateAndAssignOverlayedLanguagePath(config.overlayedLanguagesResourcePath());
        LOGGER.debug("Config values are localizationEnabled:{}, overlayedLanguagesResourcePath:{} ", (Object)this.localizationEnabled, (Object)this.overlayedLanguagesResourcePath);
        LOGGER.debug("End ACTIVATE GenericListService");
    }

    private void validateAndAssignOverlayedLanguagePath(String overlayedLanguagesResourcePath) {
        if (StringUtils.startsWith((CharSequence)overlayedLanguagesResourcePath, (CharSequence)"/apps") && StringUtils.endsWith((CharSequence)overlayedLanguagesResourcePath, (CharSequence)"languages")) {
            this.overlayedLanguagesResourcePath = overlayedLanguagesResourcePath;
        } else {
            LOGGER.warn("Not a valid overlayed languages resource path, thus ignoring it");
        }
    }

    @Override
    public boolean isLocalizationEnabled() {
        return this.localizationEnabled;
    }

    @Override
    public String getOverlayedLanguagesResourcePath() {
        return this.overlayedLanguagesResourcePath;
    }
}

