/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl.keys;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.keys.AbstractCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.sling.api.SlingHttpServletRequest;

public class GroupCacheKey
extends AbstractCacheKey
implements CacheKey,
Serializable {
    private List<String> cacheKeyUserGroups;

    public GroupCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, List<String> userGroups) throws HttpCacheKeyCreationException {
        super(request, cacheConfig);
        this.cacheKeyUserGroups = Optional.ofNullable(userGroups).map(list -> new ArrayList(list)).orElse(Collections.emptyList());
    }

    public GroupCacheKey(String uri, HttpCacheConfig cacheConfig, List<String> userGroups) throws HttpCacheKeyCreationException {
        super(uri, cacheConfig);
        this.cacheKeyUserGroups = Optional.ofNullable(userGroups).map(list -> new ArrayList(list)).orElse(Collections.emptyList());
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        GroupCacheKey that = (GroupCacheKey)o;
        return new EqualsBuilder().append((Object)this.getUri(), (Object)that.getUri()).append(this.cacheKeyUserGroups, that.cacheKeyUserGroups).append((Object)this.getAuthenticationRequirement(), (Object)that.getAuthenticationRequirement()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUri()).append(this.cacheKeyUserGroups).append((Object)this.getAuthenticationRequirement()).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder formattedString = new StringBuilder(this.uri).append(" [GROUPS:");
        formattedString.append(StringUtils.join(this.cacheKeyUserGroups, (String)"|"));
        formattedString.append("] [AUTH_REQ:" + this.getAuthenticationRequirement() + "]");
        return formattedString.toString();
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        this.parentWriteObject(o);
        Object[] userGroupArray = this.cacheKeyUserGroups.toArray();
        o.writeObject(StringUtils.join((Object[])userGroupArray, (String)","));
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        this.parentReadObject(o);
        String userGroupsStr = (String)o.readObject();
        String[] userGroupStrArray = userGroupsStr.split(",");
        this.cacheKeyUserGroups = Arrays.asList(userGroupStrArray);
    }
}

