/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.httpcache.util.UserUtils;
import com.adobe.acs.commons.util.ParameterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Cache config", description="Config for request URI patterns that have to be cached.", configurationFactory=true, metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Order: {httpcache.config.order}, Request URIs: {httpcache.config.requesturi.patterns}, Request URIs blacklist: {httpcache.config.requesturi.patterns.blacklisted}, Authentication: {httpcache.config.request.authentication}, Invalidation paths: {httpcache.config.invalidation.oak.paths}, Cache type: {httpcache.config.cachestore}"}, propertyPrivate=true)})
@Service
public class HttpCacheConfigImpl
implements HttpCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheConfigImpl.class);
    static final String FILTER_SCOPE_REQUEST = "REQUEST";
    static final String FILTER_SCOPE_INCLUDE = "INCLUDE";
    static final int DEFAULT_ORDER = 1000;
    private int order = 1000;
    @Property(label="Priority order", description="Order in which the HttpCacheEngine should evaluate the HttpCacheConfigs against the request. Evaluates smallest to largest (Integer.MIN_VALUE -> Integer.MAX_VALUE). Defaults to 1000 ", intValue={1000})
    static final String PROP_ORDER = "httpcache.config.order";
    @Property(label="Request URI patterns", description="Request URI patterns (REGEX) to be cached. Example - /content/mysite(.*).product-data.json. Mandatory parameter.", cardinality=0x7FFFFFFF)
    static final String PROP_REQUEST_URI_PATTERNS = "httpcache.config.requesturi.patterns";
    private List<String> requestUriPatterns;
    private List<Pattern> requestUriPatternsAsRegEx = Collections.emptyList();
    @Property(label="Blacklisted request URI patterns", description="Blacklisted request URI patterns (REGEX). Evaluated post applying the above request uri patterns (httpcache.config.requesturi.patterns). Optional parameter.", cardinality=0x7FFFFFFF)
    static final String PROP_BLACKLISTED_REQUEST_URI_PATTERNS = "httpcache.config.requesturi.patterns.blacklisted";
    private List<String> blacklistedRequestUriPatterns;
    private List<Pattern> blacklistedRequestUriPatternsAsRegEx = Collections.emptyList();
    @Property(label="Authentication", description="Authentication requirement.", options={@PropertyOption(name="anonymous", value="anonymous"), @PropertyOption(name="authenticated", value="authenticated"), @PropertyOption(name="both", value="both")}, value={"anonymous"})
    static final String PROP_AUTHENTICATION_REQUIREMENT = "httpcache.config.request.authentication";
    static final String DEFAULT_AUTHENTICATION_REQUIREMENT = "anonymous";
    private String authenticationRequirement;
    @Property(label="JCR path pattern (REGEX) for cache invalidation ", description="Optional set of paths in JCR (Oak) repository for which this cache has to be invalidated. This accepts REGEX. Example - /etc/my-products(.*)", cardinality=0x7FFFFFFF)
    static final String PROP_CACHE_INVALIDATION_PATH_PATTERNS = "httpcache.config.invalidation.oak.paths";
    private List<String> cacheInvalidationPathPatterns;
    private List<Pattern> cacheInvalidationPathPatternsAsRegEx = Collections.emptyList();
    @Property(label="Cache store", description="Cache store for caching the response for this request URI. Example - MEM. This should be one of the cache stores active in this installation. Mandatory parameter.", options={@PropertyOption(name="MEM", value="MEM"), @PropertyOption(name="CAFFEINE", value="CAFFEINE"), @PropertyOption(name="JCR", value="JCR")}, value={"MEM"})
    static final String PROP_CACHE_STORE = "httpcache.config.cachestore";
    static final String DEFAULT_CACHE_STORE = "MEM";
    private String cacheStore;
    static final String DEFAULT_FILTER_SCOPE = "REQUEST";
    @Property(label="Filter scope", description="Specify the scope of this HttpCacheConfig in the scope of the Sling Servlet Filter processing chain.", options={@PropertyOption(name="REQUEST", value="REQUEST"), @PropertyOption(name="INCLUDE", value="INCLUDE")}, value={"REQUEST"})
    static final String PROP_FILTER_SCOPE = "httpcache.config.filter-scope";
    private HttpCacheConfig.FilterScope filterScope;
    @Property(label="HttpCacheConfigExtension service pid", description="Service pid of target implementation of HttpCacheConfigExtension to be used. Example - (service.pid=com.adobe.acs.commons.httpcache.config.impl.GroupHttpCacheConfigExtension). Optional parameter.", value={"(service.pid=com.adobe.acs.commons.httpcache.config.impl.GroupHttpCacheConfigExtension)"})
    private static final String PROP_CACHE_CONFIG_EXTENSION_TARGET = "cacheConfigExtension.target";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, name="cacheConfigExtension")
    private volatile HttpCacheConfigExtension cacheConfigExtension;
    @Property(label="CacheKeyFactory service pid", description="Service pid of target implementation of CacheKeyFactory to be used. Example - (service.pid=com.adobe.acs.commons.httpcac`he.config.impl.GroupHttpCacheConfigExtension). Mandatory parameter.", value={"(service.pid=com.adobe.acs.commons.httpcache.config.impl.GroupHttpCacheConfigExtension)"})
    private static final String PROP_CACHE_CONFIG_FACTORY_TARGET = "cacheKeyFactory.target";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC, name="cacheKeyFactory")
    private volatile CacheKeyFactory cacheKeyFactory;
    @Property(label="Config-specific HttpCacheHandlingRules", description="List of Service pid of HttpCacheHandlingRule applicable for this cache config. Optional parameter", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_CACHE_HANDLING_RULES_PID = "httpcache.config.cache-handling-rules.pid";
    private List<String> cacheHandlingRulesPid;
    @Property(label="Config-specific Excluded Cookie keys", description="List of cookie keys that will NOT be put in the cached response, to be served to the output.parameter", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_RESPONSE_COOKIE_KEY_EXCLUSIONS = "httpcache.config.excluded.cookie.keys";
    private List<String> excludedCookieKeys;
    @Property(label="Config-specific Excluded Response headers", description="List of header keys (as regex) that should NOT be put in the cached response, to be served to the output.", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_RESPONSE_HEADER_EXCLUSIONS = "httpcache.config.excluded.response.headers";
    private List<Pattern> responseHeaderExclusions;
    @Property(label="Expiry on create", description="Specifies a custom expiry on create. Overrules the global expiry, unless the value is 0.")
    static final String PROP_EXPIRY_ON_CREATE = "httpcache.config.expiry.on.create";
    static final long DEFAULT_EXPIRY_ON_CREATE = 0L;
    private long expiryOnCreate;
    @Property(label="Expiry on access", description="Specifies a custom expiry on access. This refreshes the expiry of the entry if it's used. Lower then 0 means no expiry on access. ")
    static final String PROP_EXPIRY_ON_ACCESS = "httpcache.config.expiry.on.access";
    static final long DEFAULT_EXPIRY_ON_ACCESS = 0L;
    private long expiryOnAccess;
    @Property(label="Expiry on update", description="Specifies a custom expiry on update. This refreshes the expiry of the entry if it's updated. Lower then 0 means no expiry on update.")
    static final String PROP_EXPIRY_ON_UPDATE = "httpcache.config.expiry.on.update";
    static final long DEFAULT_EXPIRY_ON_UPDATE = 0L;
    private long expiryOnUpdate;
    private String cacheConfigExtensionTarget;
    private String cacheKeyFactoryTarget;

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.cacheConfigExtensionTarget = PropertiesUtil.toString((Object)configs.get(PROP_CACHE_CONFIG_EXTENSION_TARGET), null);
        this.cacheKeyFactoryTarget = PropertiesUtil.toString((Object)configs.get(PROP_CACHE_CONFIG_FACTORY_TARGET), null);
        this.requestUriPatterns = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_REQUEST_URI_PATTERNS), (String[])new String[0]));
        this.requestUriPatternsAsRegEx = this.compileToPatterns(this.requestUriPatterns);
        this.responseHeaderExclusions = ParameterUtil.toPatterns(PropertiesUtil.toStringArray((Object)configs.get(PROP_RESPONSE_HEADER_EXCLUSIONS), (String[])new String[0]));
        this.excludedCookieKeys = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_RESPONSE_COOKIE_KEY_EXCLUSIONS), (String[])new String[0]));
        this.blacklistedRequestUriPatterns = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_BLACKLISTED_REQUEST_URI_PATTERNS), (String[])new String[0]));
        this.blacklistedRequestUriPatternsAsRegEx = this.compileToPatterns(this.blacklistedRequestUriPatterns);
        this.authenticationRequirement = PropertiesUtil.toString((Object)configs.get(PROP_AUTHENTICATION_REQUIREMENT), (String)DEFAULT_AUTHENTICATION_REQUIREMENT);
        this.cacheStore = PropertiesUtil.toString((Object)configs.get(PROP_CACHE_STORE), (String)DEFAULT_CACHE_STORE);
        this.expiryOnCreate = PropertiesUtil.toLong((Object)configs.get(PROP_EXPIRY_ON_CREATE), (long)0L);
        this.expiryOnAccess = PropertiesUtil.toLong((Object)configs.get(PROP_EXPIRY_ON_ACCESS), (long)0L);
        this.expiryOnUpdate = PropertiesUtil.toLong((Object)configs.get(PROP_EXPIRY_ON_UPDATE), (long)0L);
        this.cacheInvalidationPathPatterns = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_CACHE_INVALIDATION_PATH_PATTERNS), (String[])new String[0]));
        this.cacheInvalidationPathPatternsAsRegEx = this.compileToPatterns(this.cacheInvalidationPathPatterns);
        this.order = PropertiesUtil.toInteger((Object)configs.get(PROP_ORDER), (int)1000);
        this.filterScope = HttpCacheConfig.FilterScope.valueOf(PropertiesUtil.toString((Object)configs.get(PROP_FILTER_SCOPE), (String)"REQUEST").toUpperCase());
        this.cacheHandlingRulesPid = new ArrayList<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_CACHE_HANDLING_RULES_PID), (String[])new String[0])));
        ListIterator<String> listIterator = this.cacheHandlingRulesPid.listIterator();
        while (listIterator.hasNext()) {
            String value = listIterator.next();
            if (!StringUtils.isBlank((String)value)) continue;
            listIterator.remove();
        }
        log.info("HttpCacheConfigImpl activated.");
    }

    private List<Pattern> compileToPatterns(List<String> regexes) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : regexes) {
            if (!StringUtils.isNotBlank((String)regex)) continue;
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    @Deactivate
    protected void deactivate(Map<String, Object> configs) {
        log.info("HttpCacheConfigImpl deactivated.");
    }

    @Override
    public String getCacheStoreName() {
        return this.cacheStore;
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request) throws HttpCacheRepositoryAccessException {
        String uri;
        if (UserUtils.isAnonymous(request.getResourceResolver().getUserID())) {
            if ("authenticated".equals(this.authenticationRequirement)) {
                log.trace("Rejected: Request is anonymous but the config accepts only authenticated request and hence reject");
                return false;
            }
        } else if (DEFAULT_AUTHENTICATION_REQUIREMENT.equals(this.authenticationRequirement)) {
            log.trace("Rejected: Request is authenticated but config is for anonymous and hence reject.");
            return false;
        }
        if (!this.matches(this.requestUriPatternsAsRegEx, uri = request.getRequestURI())) {
            log.trace("Rejected: Request URI does not match the white-listed URI patterns");
            return false;
        }
        if (this.matches(this.blacklistedRequestUriPatternsAsRegEx, uri)) {
            log.trace("Rejected: Request URI does match a black-listed URI pattern");
            return false;
        }
        if (null != this.cacheConfigExtension) {
            return this.cacheConfigExtension.accepts(request, this);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.cacheConfigExtensionTarget)) {
            log.error("Cache Config not found! Extension target: {} Factory target: {} ", (Object)this.cacheConfigExtensionTarget, (Object)this.cacheKeyFactoryTarget);
        }
        return true;
    }

    private boolean matches(List<Pattern> patterns, String data) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(data);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CacheKey buildCacheKey(SlingHttpServletRequest request) throws HttpCacheKeyCreationException {
        return this.cacheKeyFactory.build(request, (HttpCacheConfig)this);
    }

    @Override
    public CacheKey buildCacheKey(String resourcePath) throws HttpCacheKeyCreationException {
        return this.cacheKeyFactory.build(resourcePath, (HttpCacheConfig)this);
    }

    @Override
    public boolean isValid() {
        return CollectionUtils.isNotEmpty(this.requestUriPatterns);
    }

    @Override
    public boolean canInvalidate(String path) {
        return this.matches(this.cacheInvalidationPathPatternsAsRegEx, path);
    }

    @Override
    public String getAuthenticationRequirement() {
        return this.authenticationRequirement;
    }

    @Override
    public List<Pattern> getRequestUriPatterns() {
        return Collections.unmodifiableList(this.requestUriPatternsAsRegEx);
    }

    @Override
    public List<Pattern> getBlacklistedRequestUriPatterns() {
        return Collections.unmodifiableList(this.blacklistedRequestUriPatternsAsRegEx);
    }

    @Override
    public List<Pattern> getJCRInvalidationPathPatterns() {
        return Collections.unmodifiableList(this.cacheInvalidationPathPatternsAsRegEx);
    }

    @Override
    public boolean knows(CacheKey key) throws HttpCacheKeyCreationException {
        return this.cacheKeyFactory.doesKeyMatchConfig(key, this);
    }

    @Override
    public long getExpiryOnCreate() {
        return this.expiryOnCreate;
    }

    @Override
    public long getExpiryForAccess() {
        return this.expiryOnAccess;
    }

    @Override
    public long getExpiryForUpdate() {
        return this.expiryOnUpdate;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean acceptsRule(String servicePid) {
        return this.cacheHandlingRulesPid.contains(servicePid);
    }

    @Override
    public HttpCacheConfig.FilterScope getFilterScope() {
        return this.filterScope;
    }

    @Override
    public List<Pattern> getExcludedResponseHeaderPatterns() {
        return Collections.unmodifiableList(this.responseHeaderExclusions);
    }

    @Override
    public List<String> getExcludedCookieKeys() {
        return Collections.unmodifiableList(this.excludedCookieKeys);
    }

    protected void bindCacheConfigExtension(HttpCacheConfigExtension httpCacheConfigExtension) {
        this.cacheConfigExtension = httpCacheConfigExtension;
    }

    protected void unbindCacheConfigExtension(HttpCacheConfigExtension httpCacheConfigExtension) {
        if (this.cacheConfigExtension == httpCacheConfigExtension) {
            this.cacheConfigExtension = null;
        }
    }

    protected void bindCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        this.cacheKeyFactory = cacheKeyFactory;
    }

    protected void unbindCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        if (this.cacheKeyFactory == cacheKeyFactory) {
            this.cacheKeyFactory = null;
        }
    }
}

