/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.impl;

import com.adobe.acs.commons.http.HttpClientFactory;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(label="ACS AEM Commons - Http Components Fluent Executor Factory", description="ACS AEM Commons - Http Components Fluent Executor Factory", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Service
@Property(label="Factory Name", description="Name of this factory", name="factory.name")
public class HttpClientFactoryImpl
implements HttpClientFactory {
    public static final boolean DEFAULT_USE_SSL = false;
    public static final boolean DEFAULT_DISABLE_CERT_CHECK = false;
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    @Property(label="host name", description="host name")
    private static final String PROP_HOST_DOMAIN = "hostname";
    @Property(label="port", description="port")
    private static final String PROP_GATEWAY_PORT = "port";
    @Property(label="Use SSL", description="Select it if only using https connection for calls.", boolValue={false})
    private static final String PROP_USE_SSL = "use.ssl";
    @Property(label="Disable certificate check", description="If selected it will disable certificate check for the SSL connection.", boolValue={false})
    private static final String PROP_DISABLE_CERT_CHECK = "disable.certificate.check";
    @Property(label="Username", description="Username for requests (using basic authentication)")
    private static final String PROP_USERNAME = "username";
    @Property(label="Password", description="Password for requests (using basic authentication)")
    private static final String PROP_PASSWORD = "password";
    @Property(label="Socket Timeout", description="Socket timeout in milliseconds", intValue={30000})
    private static final String PROP_SO_TIMEOUT = "so.timeout";
    @Property(label="Connect Timeout", description="Connect timeout in milliseconds", intValue={30000})
    private static final String PROP_CONNECT_TIMEOUT = "conn.timeout";
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;
    private Executor executor;
    private String baseUrl;
    private CloseableHttpClient httpClient;

    @Activate
    protected void activate(Map<String, Object> config) throws Exception {
        boolean useSSL = PropertiesUtil.toBoolean((Object)config.get(PROP_USE_SSL), (boolean)false);
        String scheme = useSSL ? "https" : "http";
        String hostname = PropertiesUtil.toString((Object)config.get(PROP_HOST_DOMAIN), null);
        int port = PropertiesUtil.toInteger((Object)config.get(PROP_GATEWAY_PORT), (int)0);
        if (hostname == null || port == 0) {
            throw new IllegalArgumentException("Configuration not valid. Both host and port must be provided.");
        }
        this.baseUrl = String.format("%s://%s:%s", scheme, hostname, port);
        int connectTimeout = PropertiesUtil.toInteger((Object)config.get(PROP_CONNECT_TIMEOUT), (int)30000);
        int soTimeout = PropertiesUtil.toInteger((Object)config.get(PROP_SO_TIMEOUT), (int)30000);
        HttpClientBuilder builder = this.httpClientBuilderFactory.newBuilder();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(soTimeout).build();
        builder.setDefaultRequestConfig(requestConfig);
        boolean disableCertCheck = PropertiesUtil.toBoolean((Object)config.get(PROP_DISABLE_CERT_CHECK), (boolean)false);
        if (useSSL && disableCertCheck) {
            SSLContextBuilder sslbuilder = new SSLContextBuilder();
            sslbuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslbuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        this.httpClient = builder.build();
        this.executor = Executor.newInstance((HttpClient)this.httpClient);
        String username = PropertiesUtil.toString((Object)config.get(PROP_USERNAME), null);
        String password = PropertiesUtil.toString((Object)config.get(PROP_PASSWORD), null);
        if (username != null && password != null) {
            HttpHost httpHost = new HttpHost(hostname, port, useSSL ? "https" : "http");
            this.executor.auth(httpHost, username, password).authPreemptive(httpHost);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Request get(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Get((String)url);
    }

    @Override
    public Request post(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Post((String)url);
    }

    @Override
    public Request put(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Put((String)url);
    }

    @Override
    public Request delete(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Delete((String)url);
    }

    @Override
    public Request options(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Options((String)url);
    }

    protected void bindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        this.httpClientBuilderFactory = httpClientBuilderFactory;
    }

    protected void unbindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        if (this.httpClientBuilderFactory == httpClientBuilderFactory) {
            this.httpClientBuilderFactory = null;
        }
    }
}

