/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.data;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Variant {
    private Class baseType = null;
    private static final FastDateFormat STANDARD_DATE_FORMAT = FastDateFormat.getDateTimeInstance((int)3, (int)3);
    private Optional<Long> longVal = Optional.empty();
    private Optional<Double> doubleVal = Optional.empty();
    private Optional<String> stringVal = Optional.empty();
    private Optional<Boolean> booleanVal = Optional.empty();
    private Optional<Date> dateVal = Optional.empty();
    private static final FastDateFormat[] DATE_FORMATS = new FastDateFormat[]{FastDateFormat.getDateInstance((int)3), FastDateFormat.getDateInstance((int)1), FastDateFormat.getTimeInstance((int)3), FastDateFormat.getTimeInstance((int)1), STANDARD_DATE_FORMAT, FastDateFormat.getDateTimeInstance((int)1, (int)3), FastDateFormat.getDateTimeInstance((int)3, (int)1), FastDateFormat.getDateTimeInstance((int)1, (int)1), FastDateFormat.getDateTimeInstance((int)0, (int)0), FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX")};

    public Variant() {
    }

    public <T> Variant(T src) {
        this.setValue(src);
    }

    public Variant(Cell src) {
        this(src, Locale.getDefault());
    }

    public Variant(Cell src, Locale locale) {
        this.setValue(src, locale);
    }

    public void clear() {
        this.longVal = Optional.empty();
        this.doubleVal = Optional.empty();
        this.stringVal = Optional.empty();
        this.booleanVal = Optional.empty();
        this.dateVal = Optional.empty();
    }

    public boolean isEmpty() {
        return !this.stringVal.isPresent() && !this.longVal.isPresent() && !this.doubleVal.isPresent() && !this.dateVal.isPresent() && !this.booleanVal.isPresent();
    }

    private void setValue(Cell cell, Locale locale) {
        try {
            CellType cellType = CellType.fromObject(MethodUtils.invokeMethod((Object)cell, (String)"getCellType"));
            if (cellType == CellType.FORMULA) {
                cellType = CellType.fromObject(MethodUtils.invokeMethod((Object)cell, (String)"getCachedFormulaResultType"));
            }
            switch (cellType) {
                case BOOLEAN: {
                    this.setValue(cell.getBooleanCellValue());
                    break;
                }
                case NUMERIC: {
                    double number = cell.getNumericCellValue();
                    if (Math.floor(number) == number) {
                        this.setValue((long)number);
                    } else {
                        this.setValue(number);
                    }
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        this.setValue(cell.getDateCellValue());
                        this.baseType = Calendar.class;
                    }
                    DataFormatter dataFormatter = new DataFormatter(locale);
                    if (cellType == CellType.FORMULA) {
                        this.setValue(dataFormatter.formatCellValue(cell));
                        break;
                    }
                    CellStyle cellStyle = cell.getCellStyle();
                    this.setValue(dataFormatter.formatRawCellContents(cell.getNumericCellValue(), (int)cellStyle.getDataFormat(), cellStyle.getDataFormatString()));
                    break;
                }
                case STRING: {
                    this.setValue(cell.getStringCellValue().trim());
                    break;
                }
                default: {
                    this.clear();
                    break;
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            Logger.getLogger(Variant.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final <T> void setValue(T val) {
        if (val == null) {
            return;
        }
        Class<?> valueType = val.getClass();
        if (valueType == Variant.class) {
            Variant v = (Variant)val;
            this.longVal = v.longVal;
            this.doubleVal = v.doubleVal;
            this.stringVal = v.stringVal;
            this.booleanVal = v.booleanVal;
            this.dateVal = v.dateVal;
            this.baseType = v.baseType;
        } else if (valueType == Byte.TYPE || valueType == Byte.class) {
            this.setLongVal(((Byte)val).longValue());
            if (this.baseType == null || this.baseType == String.class) {
                this.baseType = Long.TYPE;
            }
        } else if (valueType == Integer.TYPE || valueType == Integer.class) {
            this.setLongVal(((Integer)val).longValue());
            if (this.baseType == null || this.baseType == String.class) {
                this.baseType = Long.TYPE;
            }
        } else if (valueType == Long.TYPE || valueType == Long.class) {
            this.setLongVal((Long)val);
            if (this.baseType == null || this.baseType == String.class) {
                this.baseType = Long.TYPE;
            }
        } else if (valueType == Short.TYPE || valueType == Short.class) {
            this.setLongVal(((Short)val).longValue());
            if (this.baseType == null || this.baseType == String.class) {
                this.baseType = Long.TYPE;
            }
        } else if (valueType == Float.TYPE || valueType == Float.class || valueType == Double.TYPE || valueType == Double.class) {
            this.setDoubleVal((Double)val);
            if (this.baseType == null || this.baseType == String.class) {
                this.baseType = Double.TYPE;
            }
        } else if (valueType == Boolean.TYPE || valueType == Boolean.class) {
            this.setBooleanVal((Boolean)val);
            if (this.baseType == null || this.baseType == String.class) {
                this.baseType = Boolean.TYPE;
            }
        } else if (valueType == String.class) {
            this.setStringVal((String)val);
            if (this.baseType == null) {
                this.baseType = String.class;
            }
        } else if (valueType == Date.class) {
            this.setDateVal((Date)val);
            this.baseType = Calendar.class;
        } else if (valueType == Instant.class) {
            this.setDateVal(new Date(((Instant)val).toEpochMilli()));
            this.baseType = Calendar.class;
        } else if (Calendar.class.isAssignableFrom(valueType)) {
            this.setDateVal(((Calendar)val).getTime());
            this.baseType = Calendar.class;
        } else {
            this.setStringVal(String.valueOf(val));
            if (this.baseType == null) {
                this.baseType = String.class;
            }
        }
    }

    private void setLongVal(Long l) {
        this.longVal = l == null ? Optional.empty() : Optional.of(l);
    }

    private void setDoubleVal(Double d) {
        this.doubleVal = d == null ? Optional.empty() : Optional.of(d);
    }

    private void setStringVal(String s) {
        this.stringVal = s != null && !s.isEmpty() ? Optional.of(s) : Optional.empty();
    }

    private void setBooleanVal(Boolean b) {
        this.booleanVal = b == null ? Optional.empty() : Optional.of(b);
    }

    private void setDateVal(Date d) {
        this.dateVal = d == null ? Optional.empty() : Optional.of(d);
    }

    public Long toLong() {
        return this.longVal.orElse(this.dateVal.map(Date::getTime).orElse(this.doubleVal.map(Double::longValue).orElse(this.booleanVal.map(b -> b != false ? 1L : 0L).orElseGet(() -> {
            try {
                return this.stringVal.map(s -> (long)Double.parseDouble(s)).orElse(null);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }))));
    }

    public Double toDouble() {
        return this.doubleVal.orElse(this.longVal.map(Long::doubleValue).orElse(this.booleanVal.map(b -> b != false ? 1.0 : 0.0).orElseGet(() -> {
            try {
                return this.stringVal.map(Double::parseDouble).orElse(null);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        })));
    }

    public String toString() {
        return this.stringVal.orElse(this.dateVal.map(arg_0 -> ((FastDateFormat)STANDARD_DATE_FORMAT).format(arg_0)).orElse(this.doubleVal.map(String::valueOf).orElse(this.longVal.map(String::valueOf).orElse(this.booleanVal.map(String::valueOf).orElse(null)))));
    }

    public Date toDate() {
        return this.dateVal.orElse(this.longVal.map(Date::new).orElse(this.stringVal.map(s -> {
            for (FastDateFormat format : DATE_FORMATS) {
                try {
                    return format.parse(s);
                }
                catch (ParseException parseException) {
                }
            }
            return null;
        }).orElse(null)));
    }

    public Boolean toBoolean() {
        return this.booleanVal.orElse(this.longVal.map(l -> l != 0L).orElse(this.doubleVal.map(d -> d != 0.0).orElse(this.stringVal.map(this::isStringTruthy).orElse(null))));
    }

    public boolean isStringTruthy(String s) {
        if (s == null || s.trim().isEmpty()) {
            return false;
        }
        if (StringUtils.isNumeric((String)s)) {
            return Long.parseLong(s) != 0L;
        }
        char c = s.trim().toLowerCase().charAt(0);
        return c == 't' || c == 'y' || c == 'x';
    }

    private <U, T> T apply(U value, Function<U, T> func) {
        return value == null ? null : (T)func.apply(value);
    }

    public <T> T asType(Class<T> type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return (T)this.apply(this.toLong(), Long::byteValue);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)this.apply(this.toLong(), Long::intValue);
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)this.toLong();
        }
        if (type == Short.TYPE || type == Short.class) {
            return (T)this.apply(this.toLong(), Long::shortValue);
        }
        if (type == Float.TYPE || type == Float.class) {
            return (T)this.apply(this.toDouble(), Double::floatValue);
        }
        if (type == Double.TYPE || type == Double.class) {
            return (T)this.toDouble();
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return (T)this.toBoolean();
        }
        if (type == String.class) {
            return (T)this.toString();
        }
        if (type == Date.class) {
            return (T)this.toDate();
        }
        if (type == Instant.class) {
            return (T)this.toDate().toInstant();
        }
        if (Calendar.class.isAssignableFrom(type)) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.toDate());
            return (T)c;
        }
        return null;
    }

    public static <S, D> D convert(S val, Class<D> destType) {
        Variant v = new Variant(val);
        return v.asType(destType);
    }

    Class getBaseType() {
        return this.baseType;
    }

    public static enum CellType {
        _NONE(3),
        NUMERIC(0),
        STRING(1),
        FORMULA(2),
        BLANK(3),
        BOOLEAN(4),
        ERROR(5);

        int ord;

        private CellType(int ord) {
            this.ord = ord;
        }

        public static CellType fromObject(Object o) {
            if (o.getClass() == String.class || o.getClass().isEnum()) {
                return CellType.valueOf(o.toString());
            }
            int num = (Integer)o;
            for (CellType ct : CellType.values()) {
                if (ct.ord != num) continue;
                return ct;
            }
            return null;
        }
    }
}

