/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.cloudconfig.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.post.HtmlResponse;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=acs-commons/components/utilities/cloudconfig/cloudconfiglist"})
public class CreateCloudConfigServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -397622433323474345L;
    private static final Logger log = LoggerFactory.getLogger(CreateCloudConfigServlet.class);

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
        HtmlResponse resp = new HtmlResponse();
        if (pageManager == null) {
            resp.setError((Throwable)new IOException("Unable to get page manager"));
        } else {
            String configPath = this.getParam(request, "configPath");
            Resource cloudConfigFolder = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)(configPath + "/settings/cloudconfigs"), Collections.singletonMap("jcr:primaryType", "sling:Folder"), (String)"sling:Folder", (boolean)false);
            log.debug("Creating Cloud Config in: {}", (Object)cloudConfigFolder);
            resp.setParentLocation(cloudConfigFolder.getPath());
            try {
                Page page = pageManager.create(cloudConfigFolder.getPath(), this.getParam(request, "name"), this.getParam(request, "template"), this.getParam(request, "title"));
                resp.setPath(page.getPath());
                resp.setLocation(page.getPath());
                resp.setStatus(200, "Created Cloud Configuration");
                log.debug("Created configuration: {}", (Object)page.getPath());
                resolver.commit();
            }
            catch (WCMException e) {
                resp.setError((Throwable)e);
            }
        }
        response.setContentType("text/plain");
        resp.send((HttpServletResponse)response, true);
    }

    private String getParam(SlingHttpServletRequest request, String param) throws IOException {
        String value = request.getParameter(param);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IOException("Parameter " + param + " must not be blank");
        }
        log.debug("Loaded {} for parameter {}", (Object)value, (Object)param);
        return value;
    }
}

