/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.util.visitors.ContentVisitor;
import com.adobe.acs.commons.util.visitors.ResourceRunnable;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowRunnerAccessor;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Workflow Process - Synthetic Workflow Wrapper Process", description="Executes an AEM Workflow model as a Synthetic Workflow using FAM")
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"Synthetic Workflow Wrapper"}, description="Executes an AEM Workflow model as a Synthetic Workflow (serial execution)")})
@Service
public class SyntheticWrapperWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWrapperWorkflowProcess.class);
    private static final String ARG_TRAVERSE_TREE = "traverseTree";
    private static final String ARG_SAVE_INTERVAL = "saveInterval";
    private static final String ARG_WORKFLOW_MODEL_ID = "workflowModelId";
    private static final String ARG_THROTTLE = "throttle";
    @Reference
    private SyntheticWorkflowRunnerAccessor syntheticWorkflowRunnerAccessor;
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;
    @Reference
    private WorkflowHelper workflowHelper;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resourceResolver = null;
        final SyntheticWorkflowRunner syntheticWorkflowRunner = this.syntheticWorkflowRunnerAccessor.getSyntheticWorkflowRunner();
        String payload = (String)workItem.getWorkflowData().getPayload();
        final ProcessArgs processArgs = new ProcessArgs(metaDataMap);
        try {
            resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);
            final SyntheticWorkflowModel syntheticWorkflowModel = syntheticWorkflowRunner.getSyntheticWorkflowModel(resourceResolver, processArgs.getWorkflowModelId(), true);
            final AtomicInteger count = new AtomicInteger(0);
            ResourceRunnable syntheticRunnable = new ResourceRunnable(){

                @Override
                public void run(Resource resource) throws Exception {
                    if (processArgs.isThrottle()) {
                        SyntheticWrapperWorkflowProcess.this.throttledTaskRunner.waitForLowCpuAndLowMemory();
                    }
                    syntheticWorkflowRunner.execute(resource.getResourceResolver(), resource.getPath(), syntheticWorkflowModel, false, false);
                    if (processArgs.getSaveInterval() > 0 && count.incrementAndGet() % processArgs.getSaveInterval() == 0 && resource.getResourceResolver().hasChanges()) {
                        resource.getResourceResolver().commit();
                    }
                }
            };
            ContentVisitor<1> visitor = new ContentVisitor<1>(syntheticRunnable);
            Resource resource = resourceResolver.getResource(payload);
            if (processArgs.isTraverseTree()) {
                visitor.accept(resource);
            } else {
                syntheticRunnable.run(resource);
            }
            if (processArgs.getSaveInterval() > 0 && resourceResolver.hasChanges()) {
                resourceResolver.commit();
            }
            log.info("Synthetic Workflow Wrapper processed [ {} ] total payloads", (Object)count.get());
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected void bindSyntheticWorkflowRunnerAccessor(SyntheticWorkflowRunnerAccessor syntheticWorkflowRunnerAccessor) {
        this.syntheticWorkflowRunnerAccessor = syntheticWorkflowRunnerAccessor;
    }

    protected void unbindSyntheticWorkflowRunnerAccessor(SyntheticWorkflowRunnerAccessor syntheticWorkflowRunnerAccessor) {
        if (this.syntheticWorkflowRunnerAccessor == syntheticWorkflowRunnerAccessor) {
            this.syntheticWorkflowRunnerAccessor = null;
        }
    }

    protected void bindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.throttledTaskRunner = throttledTaskRunner;
    }

    protected void unbindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.throttledTaskRunner == throttledTaskRunner) {
            this.throttledTaskRunner = null;
        }
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }

    private static class ProcessArgs {
        private boolean traverseTree = false;
        private boolean throttle = false;
        private String workflowModelId;
        int saveInterval;

        public ProcessArgs(MetaDataMap map) throws WorkflowException {
            String[] lines = StringUtils.split((String)((String)map.get("PROCESS_ARGS", (Object)"")), (String)System.lineSeparator());
            Map<String, String> data = ParameterUtil.toMap(lines, "=");
            this.throttle = Boolean.parseBoolean(data.get(SyntheticWrapperWorkflowProcess.ARG_THROTTLE));
            this.traverseTree = Boolean.parseBoolean(data.get(SyntheticWrapperWorkflowProcess.ARG_TRAVERSE_TREE));
            this.workflowModelId = data.get(SyntheticWrapperWorkflowProcess.ARG_WORKFLOW_MODEL_ID);
            try {
                this.saveInterval = Integer.parseInt(data.get(SyntheticWrapperWorkflowProcess.ARG_SAVE_INTERVAL));
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse int from [ {} ]", (Object)data.get(SyntheticWrapperWorkflowProcess.ARG_SAVE_INTERVAL));
                this.saveInterval = 100;
            }
            if (StringUtils.isBlank((CharSequence)this.workflowModelId)) {
                throw new WorkflowException("Unable to parse the workflowModelId from the Workflow Process Args");
            }
        }

        public String getWorkflowModelId() {
            return this.workflowModelId;
        }

        public boolean isTraverseTree() {
            return this.traverseTree;
        }

        public int getSaveInterval() {
            return this.saveInterval;
        }

        public boolean isThrottle() {
            return this.throttle;
        }
    }
}

