/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Session;

public class ReplicatorQueue {
    private Map<String, ReplicationOptions> deactivateOperations = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, ReplicationOptions> activateOperations = Collections.synchronizedMap(new LinkedHashMap());

    public void replicate(Session session, ReplicationActionType actionType, String path) throws ReplicationException {
        this.replicate(session, actionType, path, null);
    }

    public void replicate(Session session, ReplicationActionType actionType, String path, ReplicationOptions replicationOptions) throws ReplicationException {
        Map<String, ReplicationOptions> queue;
        switch (actionType) {
            case ACTIVATE: {
                queue = this.getActivateOperations();
                break;
            }
            case DEACTIVATE: 
            case DELETE: {
                queue = this.getDeactivateOperations();
                break;
            }
            default: {
                queue = null;
            }
        }
        if (queue != null) {
            queue.put(path, replicationOptions);
        }
    }

    public Map<String, ReplicationOptions> getDeactivateOperations() {
        return this.deactivateOperations;
    }

    public Map<String, ReplicationOptions> getActivateOperations() {
        return this.activateOperations;
    }
}

