/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;

public final class WorkflowRemovalConfig {
    private final Collection<String> modelIds;
    private final Collection<String> statuses;
    private final Collection<Pattern> payloads;
    private final Calendar olderThan;
    private final long olderThanMillis;
    private int batchSize = 1000;
    private int maxDurationInMins = 0;

    public WorkflowRemovalConfig(Collection<String> modelIds, Collection<String> statuses, Collection<Pattern> payloads, Calendar olderThan, long olderThanMillis) {
        this.modelIds = Optional.ofNullable(modelIds).map(coll -> new ArrayList(coll)).orElse(Collections.emptyList());
        this.statuses = Optional.ofNullable(statuses).map(coll -> new ArrayList(coll)).orElse(Collections.emptyList());
        this.payloads = Optional.ofNullable(payloads).map(coll -> new ArrayList(coll)).orElse(Collections.emptyList());
        this.olderThan = olderThan;
        this.olderThanMillis = olderThanMillis;
    }

    public final Collection<String> getModelIds() {
        return Collections.unmodifiableCollection(this.modelIds);
    }

    public final Collection<String> getStatuses() {
        return Collections.unmodifiableCollection(this.statuses);
    }

    public final Collection<Pattern> getPayloads() {
        return Collections.unmodifiableCollection(this.payloads);
    }

    public final Calendar getOlderThan() {
        return this.olderThan;
    }

    public final long getOlderThanMillis() {
        return this.olderThanMillis;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final int getMaxDurationInMins() {
        return this.maxDurationInMins;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public final void setMaxDurationInMins(int maxDurationInMins) {
        this.maxDurationInMins = maxDurationInMins;
    }
}

