/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.runners;

import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractAEMWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.jobs.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class AEMWorkflowRunnerImpl
extends AbstractAEMWorkflowRunner
implements BulkWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(AEMWorkflowRunnerImpl.class);
    @Reference
    private WorkflowService workflowService;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private JobManager jobManager;

    @Override
    public Runnable getRunnable(Config config) {
        return new AEMWorkflowRunnable(config, this.scheduler, this.resourceResolverFactory, this.workflowService);
    }

    @Override
    public ScheduleOptions getOptions(Config config) {
        ScheduleOptions options = this.scheduler.NOW(-1, (long)config.getInterval());
        options.canRunConcurrently(false);
        options.onLeaderOnly(true);
        options.name(config.getWorkspace().getJobName());
        return options;
    }

    @Override
    public void complete(Workspace workspace, Payload payload) throws Exception {
        super.complete(workspace, payload);
        if (workspace.getConfig().isPurgeWorkflow()) {
            try {
                this.purge(payload);
            }
            catch (WorkflowException e) {
                throw new Exception(e);
            }
        }
    }

    @Override
    public void forceTerminate(Workspace workspace, Payload payload) throws Exception {
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)payload.getResourceResolver().adaptTo(Session.class));
        Workflow workflow = null;
        this.fail(workspace, payload);
        try {
            workflow = payload.getWorkflow();
            if (workflow != null) {
                if (workflow.isActive()) {
                    workflowSession.terminateWorkflow(workflow);
                    log.info("Force Terminated workflow [ {} ]", (Object)workflow.getId());
                    payload.setStatus(Status.FORCE_TERMINATED);
                    if (workspace.getConfig().isPurgeWorkflow()) {
                        this.purge(payload);
                    }
                } else {
                    log.warn("Trying to force terminate an inactive workflow [ {} ]", (Object)workflow.getId());
                }
            } else {
                payload.setStatus(Status.FORCE_TERMINATED);
            }
        }
        catch (WorkflowException e) {
            throw new Exception(e);
        }
    }

    private void purge(Payload payload) throws PersistenceException, WorkflowException {
        Workflow workflow = payload.getWorkflow();
        if (workflow != null) {
            ResourceResolver resourceResolver = payload.getResourceResolver();
            Resource resource = resourceResolver.getResource(workflow.getId());
            if (resource != null) {
                try {
                    String path = resource.getPath();
                    ((Node)resource.adaptTo(Node.class)).remove();
                    log.info("Purging working instance [ {} ]", (Object)path);
                }
                catch (RepositoryException e) {
                    throw new PersistenceException("Unable to purge workflow instance node.", (Throwable)e);
                }
            } else {
                log.warn("Could not find workflow instance at [ {} ] to purge.", (Object)workflow.getId());
            }
        }
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected class AEMWorkflowRunnable
    implements Runnable {
        private final ResourceResolverFactory resourceResolverFactory;
        private final WorkflowService workflowService;
        private final Scheduler scheduler;
        private String configPath;
        private String jobName;

        public AEMWorkflowRunnable(Config config, Scheduler scheduler, ResourceResolverFactory resourceResolverFactory, WorkflowService workflowService) {
            this.configPath = config.getPath();
            this.jobName = config.getWorkspace().getJobName();
            this.resourceResolverFactory = resourceResolverFactory;
            this.workflowService = workflowService;
            this.scheduler = scheduler;
        }

        @Override
        public void run() {
            log.debug("Running Bulk AEM Workflow job [ {} ]", (Object)this.jobName);
            Resource configResource = null;
            Config config = null;
            Workspace workspace = null;
            try (ResourceResolver adminResourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AbstractWorkflowRunner.AUTH_INFO);){
                configResource = adminResourceResolver.getResource(this.configPath);
                if (configResource != null) {
                    config = (Config)configResource.adaptTo(Config.class);
                }
                if (config == null) {
                    log.error("Bulk workflow process resource [ {} ] could not be found. Removing periodic job.", (Object)this.configPath);
                    this.scheduler.unschedule(this.jobName);
                } else {
                    Payload payload;
                    workspace = config.getWorkspace();
                    if (workspace.isStopped() || workspace.isStopping()) {
                        AEMWorkflowRunnerImpl.this.unscheduleJob(this.scheduler, this.jobName, configResource, workspace);
                        AEMWorkflowRunnerImpl.this.stop(workspace);
                        return;
                    }
                    List<Payload> priorActivePayloads = workspace.getActivePayloads();
                    ArrayList<Payload> currentActivePayloads = new ArrayList<Payload>();
                    for (Payload payload2 : priorActivePayloads) {
                        log.debug("Checking status of payload [ {} ~> {} ]", (Object)payload2.getPath(), (Object)payload2.getPayloadPath());
                        try {
                            Workflow workflow = payload2.getWorkflow();
                            if (workflow == null) {
                                AEMWorkflowRunnerImpl.this.forceTerminate(workspace, payload2);
                                log.warn("Force terminated payload [ {} ] when running under a non-transient Workflow, as workflow is null.", (Object)payload2.getPath());
                                continue;
                            }
                            if (!workflow.isActive()) {
                                payload2.updateWith(workflow);
                                AEMWorkflowRunnerImpl.this.complete(workspace, payload2);
                                continue;
                            }
                            Calendar expiresAt = Calendar.getInstance();
                            expiresAt.setTime(workflow.getTimeStarted());
                            expiresAt.add(13, config.getTimeout());
                            if (!Calendar.getInstance().before(expiresAt)) {
                                payload2.updateWith(workflow);
                                AEMWorkflowRunnerImpl.this.forceTerminate(workspace, payload2);
                                log.warn("Force terminated payload [ {} ~> {} ] as processing time has expired.", (Object)payload2.getPath(), (Object)payload2.getPayloadPath());
                                continue;
                            }
                            payload2.updateWith(workflow);
                            currentActivePayloads.add(payload2);
                        }
                        catch (WorkflowException e) {
                            AEMWorkflowRunnerImpl.this.forceTerminate(workspace, payload2);
                        }
                        catch (Exception e) {
                            log.error("Error while processing payload [ {} ~> {} ]", (Object)payload2.getPath(), (Object)payload2.getPayloadPath());
                            AEMWorkflowRunnerImpl.this.forceTerminate(workspace, payload2);
                        }
                    }
                    int capacity = config.getBatchSize() - currentActivePayloads.size();
                    WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)adminResourceResolver.adaptTo(Session.class));
                    WorkflowModel workflowModel = workflowSession.getModel(config.getWorkflowModelId());
                    boolean dirty = false;
                    while (capacity > 0 && (payload = AEMWorkflowRunnerImpl.this.onboardNextPayload(workspace)) != null) {
                        log.trace("Onboarding payload [ {} ~> {} ]", (Object)payload.getPath(), (Object)payload.getPayloadPath());
                        Workflow workflow = workflowSession.startWorkflow(workflowModel, workflowSession.newWorkflowData("JCR_PATH", (Object)payload.getPayloadPath()));
                        if (workflow != null && workflow.getId() != null) {
                            payload.updateWith(workflow);
                            currentActivePayloads.add(payload);
                            --capacity;
                            dirty = true;
                            continue;
                        }
                        log.warn("The workflow or workflow ID is null, so something strange happened to it.");
                        AEMWorkflowRunnerImpl.this.fail(workspace, payload);
                        dirty = true;
                    }
                    AEMWorkflowRunnerImpl.this.cleanupActivePayloadGroups(workspace);
                    if (!dirty && currentActivePayloads.size() == 0) {
                        log.debug("No more payloads found to process. No more work to be done.");
                        AEMWorkflowRunnerImpl.this.complete(workspace);
                        AEMWorkflowRunnerImpl.this.unscheduleJob(this.scheduler, this.jobName, configResource, workspace);
                        log.info("Completed Bulk Workflow execution for [ {} ]", (Object)config.getPath());
                    }
                    if (workspace != null) {
                        workspace.commit();
                    }
                }
            }
            catch (Exception e) {
                String workspacePath = workspace != null ? workspace.getPath() : "unknown";
                log.error("Error processing periodic execution for job [ {} ] for workspace [ {} ]", (Object)new String[]{this.jobName, workspacePath}, (Object)e);
                AEMWorkflowRunnerImpl.this.unscheduleJob(this.scheduler, this.jobName, configResource, workspace);
                try {
                    AEMWorkflowRunnerImpl.this.stop(workspace);
                }
                catch (PersistenceException e1) {
                    log.error("Unable to mark this workspace [ {} ] as stopped.", (Object)workspacePath, (Object)e1);
                }
            }
        }
    }
}

