/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.components.impl;

import com.adobe.acs.commons.wcm.components.NamedTransformImageModel;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.foundation.Image;
import com.day.cq.wcm.foundation.Placeholder;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={NamedTransformImageModel.class}, resourceType={"acs-commons/components/content/named-transform-image"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class NamedTransformImageModelImpl
implements NamedTransformImageModel {
    @Self
    private SlingHttpServletRequest request;
    @ValueMapValue
    private String transform;
    @ValueMapValue
    private String linkURL;
    @ScriptVariable
    @Required
    private Page currentPage;
    @ScriptVariable
    @Required
    private Style currentStyle;
    private Image image;

    @PostConstruct
    protected void init() {
        Resource resource = this.request.getResource();
        this.image = new Image(resource);
        if (StringUtils.isNotBlank((CharSequence)this.transform)) {
            long imageTimestamp;
            try {
                imageTimestamp = this.image.getLastModified().getTimeInMillis();
            }
            catch (RepositoryException e) {
                imageTimestamp = -1L;
            }
            long pageTimestamp = this.currentPage.getLastModified().getTimeInMillis();
            long timestamp = imageTimestamp > pageTimestamp ? imageTimestamp : pageTimestamp;
            this.image.setSrc(resource.getPath() + ".transform/" + this.transform + "/" + timestamp + "/image." + this.image.getExtension());
        }
        this.image.setIsInUITouchMode(Placeholder.isAuthoringUIModeTouch((ServletRequest)this.request));
        this.image.addCssClass("cq-dd-image");
        this.image.loadStyleData(this.currentStyle);
        this.image.setSelector(".img");
    }

    @Override
    public String getLinkURL() {
        PageManager pageManager = (PageManager)this.request.adaptTo(PageManager.class);
        if (pageManager.getPage(this.linkURL) != null && !StringUtils.endsWith((CharSequence)this.linkURL, (CharSequence)".html")) {
            return this.linkURL + ".html";
        }
        return this.linkURL;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public boolean isReady() {
        return this.image.hasContent() && StringUtils.isNotBlank((CharSequence)this.image.getSrc());
    }
}

