/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl;

import acscommons.com.google.common.collect.Iterators;
import com.adobe.acs.commons.wcm.comparisons.VersionService;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class VersionServiceImpl
implements VersionService {
    private static final Logger log = LoggerFactory.getLogger(VersionServiceImpl.class);

    @Override
    public Version lastVersion(Resource resource) {
        try {
            Resource versionableResource = resource.isResourceType("cq:Page") ? resource.getChild("jcr:content") : resource;
            VersionManager versionManager = ((Session)versionableResource.getResourceResolver().adaptTo(Session.class)).getWorkspace().getVersionManager();
            VersionIterator allVersions = versionManager.getVersionHistory(versionableResource.getPath()).getAllVersions();
            return (Version)Iterators.getLast(allVersions);
        }
        catch (RepositoryException e) {
            log.error("Error receiving last version of resource [ {} ]", (Object)resource.getName());
            return null;
        }
    }
}

