/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.Evolution;
import com.adobe.acs.commons.version.EvolutionContext;
import com.adobe.acs.commons.version.impl.CurrentEvolutionImpl;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvolutionContextImpl
implements EvolutionContext {
    private static final Logger log = LoggerFactory.getLogger(EvolutionContext.class);
    private List<Evolution> versions = new ArrayList<Evolution>();
    private List<Evolution> evolutionItems = new ArrayList<Evolution>();

    public EvolutionContextImpl(Resource providedResource, EvolutionConfig config) {
        Resource resource = providedResource.isResourceType("cq:Page") ? providedResource.getChild("jcr:content") : providedResource;
        this.populateEvolutions(resource, config);
    }

    @Override
    public List<Evolution> getEvolutionItems() {
        return Collections.unmodifiableList(this.evolutionItems);
    }

    @Override
    public List<Evolution> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    private void populateEvolutions(Resource resource, EvolutionConfig config) {
        try {
            ResourceResolver resolver = resource.getResourceResolver();
            VersionManager versionManager = ((Session)resolver.adaptTo(Session.class)).getWorkspace().getVersionManager();
            VersionHistory history = versionManager.getVersionHistory(resource.getPath());
            VersionIterator iter = history.getAllVersions();
            while (iter.hasNext()) {
                Version next = (Version)iter.next();
                String versionPath = next.getFrozenNode().getPath();
                Resource versionResource = resolver.resolve(versionPath);
                this.versions.add(new EvolutionImpl(next, versionResource, config));
                log.debug("Version={} added to EvolutionItem", (Object)next.getName());
            }
        }
        catch (UnsupportedRepositoryOperationException e1) {
            log.warn("Could not find version for resource={}", (Object)resource.getPath());
        }
        catch (Exception e) {
            log.error("Could not find versions", (Throwable)e);
        }
        this.evolutionItems = new ArrayList<Evolution>(this.versions);
        this.evolutionItems.add(new CurrentEvolutionImpl(resource, config));
    }
}

