/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.impl.CacheMBean;
import com.adobe.acs.commons.util.impl.exception.CacheMBeanException;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.HashMap;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCacheMBean<K, V>
extends AnnotatedStandardMBean
implements CacheMBean {
    protected static final String JMX_PN_CACHESTATS = "Cache Stats";
    protected static final String JMX_PN_STAT = "Stat";
    protected static final String JMX_PN_VALUE = "Value";
    protected static final String JMX_PN_CACHEKEY = "Cache Key";
    protected static final String JMX_PN_CACHEENTRY = "Cache Entry";
    protected static final String JMX_PN_CONTENTTYPE = "Content Type";
    protected static final String JMX_PN_STATUS = "Status";
    protected static final String JMX_PN_CHARENCODING = "Character Encoding";
    protected static final String JMX_PN_SIZE = "Size";
    protected static final String JMX_PN_HITS = "Hits";
    protected static final String JMX_PN_TOTALSIZESERVED = "Total Size Served from Cache";

    public <T> AbstractCacheMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    protected AbstractCacheMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    protected abstract Map<K, V> getCacheAsMap();

    protected abstract long getBytesLength(V var1);

    protected abstract void addCacheData(Map<String, Object> var1, V var2);

    protected abstract String toString(V var1) throws CacheMBeanException;

    protected abstract CompositeType getCacheEntryType() throws OpenDataException;

    @Override
    public final long getCacheEntriesCount() {
        return this.getCacheAsMap().size();
    }

    @Override
    public final TabularData getCacheContents() throws CacheMBeanException {
        try {
            CompositeType cacheEntryType = this.getCacheEntryType();
            TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Entries", "Cache Entries", cacheEntryType, new String[]{JMX_PN_CACHEKEY}));
            Map<K, V> cacheAsMap = this.getCacheAsMap();
            for (Map.Entry<K, V> entry : cacheAsMap.entrySet()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(JMX_PN_CACHEKEY, entry.getKey().toString());
                V cacheObj = entry.getValue();
                if (cacheObj != null) {
                    this.addCacheData(data, cacheObj);
                }
                tabularData.put(new CompositeDataSupport(cacheEntryType, data));
            }
            return tabularData;
        }
        catch (OpenDataException ex) {
            throw new CacheMBeanException("Error getting the cache contents", ex);
        }
    }

    @Override
    public final String getCacheSize() {
        long size = 0L;
        Map<K, V> map = this.getCacheAsMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            size += this.getBytesLength(entry.getValue());
        }
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    @Override
    public String getCacheEntry(String cacheKeyStr) throws CacheMBeanException {
        V persistenceObject;
        Object cacheKey = null;
        Map<K, V> map = this.getCacheAsMap();
        for (K cacheKeyTmp : map.keySet()) {
            if (!StringUtils.equals((CharSequence)cacheKeyStr, (CharSequence)cacheKeyTmp.toString())) continue;
            cacheKey = cacheKeyTmp;
            break;
        }
        if (cacheKey != null && (persistenceObject = map.get(cacheKey)) != null) {
            return this.toString(persistenceObject);
        }
        return "Invalid cache key parameter.";
    }
}

